/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;
import org.rundeck.api.domain.RundeckJob;
import org.rundeck.api.parser.BaseXpathParser;

public class JobParser
extends BaseXpathParser<RundeckJob> {
    public JobParser(String xpath) {
        super(xpath);
    }

    public JobParser() {
    }

    @Override
    public RundeckJob parse(Node jobNode) {
        Node contextNode;
        RundeckJob job = new RundeckJob();
        job.setName(StringUtils.trimToNull((String)jobNode.valueOf("name")));
        job.setDescription(StringUtils.trimToNull((String)jobNode.valueOf("description")));
        job.setGroup(StringUtils.trimToNull((String)jobNode.valueOf("group")));
        String jobId = null;
        jobId = jobNode.valueOf("id");
        if (StringUtils.isBlank((String)jobId)) {
            jobId = jobNode.valueOf("@id");
        }
        job.setId(jobId);
        String averageDuration = StringUtils.trimToNull((String)jobNode.valueOf("@averageDuration"));
        if (averageDuration != null) {
            job.setAverageDuration(Long.valueOf(averageDuration));
        }
        if ((contextNode = jobNode.selectSingleNode("context")) != null) {
            job.setProject(StringUtils.trimToNull((String)contextNode.valueOf("project")));
        } else {
            job.setProject(StringUtils.trimToNull((String)jobNode.valueOf("project")));
        }
        return job;
    }
}

