/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.rundeck.api.RundeckApiException;
import org.rundeck.api.parser.BaseXpathParser;
import org.rundeck.api.parser.ListParser;
import org.rundeck.api.parser.XmlNodeParser;
import org.rundeck.api.util.PagedResults;

public class PagedResultParser<T>
implements XmlNodeParser<PagedResults<T>> {
    ListParser<T> itemParser;
    private String xpath;

    public PagedResultParser(ListParser<T> itemParser, String xpath) {
        this.itemParser = itemParser;
        this.xpath = xpath;
    }

    @Override
    public PagedResults<T> parseXmlNode(Node node) {
        Node pagedNodeContainer = BaseXpathParser.selectNodeAndUnwrap(node, this.xpath);
        if (null == pagedNodeContainer) {
            throw new RundeckApiException("XML content did not match XPATH expression: " + this.xpath);
        }
        Element el = (Element)pagedNodeContainer;
        final int max = this.integerAttribute(el, "max", -1);
        final int offset = this.integerAttribute(el, "offset", -1);
        final int total = this.integerAttribute(el, "total", -1);
        int count = this.integerAttribute(el, "count", -1);
        Object ts = this.itemParser.parseXmlNode(pagedNodeContainer);
        return new PagedResults<T>((List)ts, count){
            final /* synthetic */ List val$ts;
            final /* synthetic */ int val$count;
            {
                this.val$ts = list;
                this.val$count = n4;
            }

            @Override
            public int getMax() {
                return max;
            }

            @Override
            public int getOffset() {
                return offset;
            }

            @Override
            public int getTotal() {
                return total;
            }

            @Override
            public List<T> getResults() {
                return this.val$ts;
            }

            @Override
            public int getCount() {
                return this.val$count;
            }

            @Override
            public Iterator<T> iterator() {
                return this.val$ts.iterator();
            }
        };
    }

    private int integerAttribute(Element el, String attribute, int defValue) {
        int parseMax = defValue;
        try {
            String max1 = null != el.attribute(attribute) ? el.attribute(attribute).getStringValue() : null;
            parseMax = null != max1 ? Integer.parseInt(max1) : defValue;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return parseMax;
    }

    public String getXpath() {
        return this.xpath;
    }
}

