/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.rundeck.api.domain.BaseStorageResource;
import org.rundeck.api.domain.StorageResource;
import org.rundeck.api.parser.BaseXpathParser;
import org.rundeck.api.parser.ListParser;

public class StorageResourceParser
extends BaseXpathParser<StorageResource> {
    private BaseStorageResource holder;

    public StorageResourceParser() {
    }

    public StorageResourceParser(BaseStorageResource holder) {
        this.holder = holder;
    }

    public StorageResourceParser(String xpath) {
        super(xpath);
    }

    @Override
    public StorageResource parse(Node node) {
        String path = node.valueOf("@path");
        String type = node.valueOf("@type");
        String url = node.valueOf("@url");
        BaseStorageResource storageResource = null == this.holder ? new BaseStorageResource() : this.holder;
        storageResource.setDirectory("directory".equals(type));
        storageResource.setPath(path);
        storageResource.setUrl(url);
        if (storageResource.isDirectory()) {
            if (node.selectSingleNode("contents") != null) {
                storageResource.setDirectoryContents((List<? extends StorageResource>)new ListParser<StorageResource>(new StorageResourceParser(), "contents/resource").parseXmlNode(node));
            }
        } else {
            String name = node.valueOf("@name");
            storageResource.setName(name);
            Node meta = node.selectSingleNode("resource-meta");
            HashMap<String, String> metamap = new HashMap<String, String>();
            if (null != meta) {
                Element metaEl = (Element)meta;
                for (Object o : metaEl.elements()) {
                    Element sub = (Element)o;
                    metamap.put(sub.getName(), sub.getText().trim());
                }
            }
            storageResource.setMetadata(metamap);
        }
        return storageResource;
    }
}

