/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;
import org.rundeck.api.domain.RundeckSystemInfo;
import org.rundeck.api.parser.BaseXpathParser;

public class SystemInfoParser
extends BaseXpathParser<RundeckSystemInfo> {
    public SystemInfoParser(String xpath) {
        super(xpath);
    }

    @Override
    public RundeckSystemInfo parse(Node infoNode) {
        RundeckSystemInfo info = new RundeckSystemInfo();
        String timestamp = StringUtils.trimToNull((String)infoNode.valueOf("timestamp/@epoch"));
        if (timestamp != null) {
            info.setDate(new Date(Long.valueOf(timestamp)));
        }
        info.setVersion(StringUtils.trimToNull((String)infoNode.valueOf("rundeck/version")));
        info.setBuild(StringUtils.trimToNull((String)infoNode.valueOf("rundeck/build")));
        info.setNode(StringUtils.trimToNull((String)infoNode.valueOf("rundeck/node")));
        info.setBaseDir(StringUtils.trimToNull((String)infoNode.valueOf("rundeck/base")));
        info.setOsArch(StringUtils.trimToNull((String)infoNode.valueOf("os/arch")));
        info.setOsName(StringUtils.trimToNull((String)infoNode.valueOf("os/name")));
        info.setOsVersion(StringUtils.trimToNull((String)infoNode.valueOf("os/version")));
        info.setJvmName(StringUtils.trimToNull((String)infoNode.valueOf("jvm/name")));
        info.setJvmVendor(StringUtils.trimToNull((String)infoNode.valueOf("jvm/vendor")));
        info.setJvmVersion(StringUtils.trimToNull((String)infoNode.valueOf("jvm/version")));
        String startDate = StringUtils.trimToNull((String)infoNode.valueOf("stats/uptime/since/@epoch"));
        if (startDate != null) {
            info.setStartDate(new Date(Long.valueOf(startDate)));
        }
        info.setUptimeInMillis(Long.valueOf(infoNode.valueOf("stats/uptime/@duration")));
        info.setCpuLoadAverage(StringUtils.trimToNull((String)infoNode.valueOf("stats/cpu/loadAverage")));
        if (info.getCpuLoadAverage() != null) {
            info.setCpuLoadAverage(info.getCpuLoadAverage() + " %");
        }
        info.setMaxMemoryInBytes(Long.valueOf(infoNode.valueOf("stats/memory/max")));
        info.setFreeMemoryInBytes(Long.valueOf(infoNode.valueOf("stats/memory/free")));
        info.setTotalMemoryInBytes(Long.valueOf(infoNode.valueOf("stats/memory/total")));
        info.setRunningJobs(Integer.valueOf(infoNode.valueOf("stats/scheduler/running")));
        info.setActiveThreads(Integer.valueOf(infoNode.valueOf("stats/threads/active")));
        return info;
    }
}

