/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.AuthorizationUtil;
import com.dtolabs.rundeck.core.authorization.RuleSetValidation;
import com.dtolabs.rundeck.core.authorization.Validation;
import com.dtolabs.rundeck.core.authorization.ValidationSet;
import com.dtolabs.rundeck.core.authorization.providers.BaseValidator;
import com.dtolabs.rundeck.core.authorization.providers.CacheableYamlSource;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesValidation;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import com.dtolabs.rundeck.core.authorization.providers.ValidatorFactory;
import com.dtolabs.rundeck.core.authorization.providers.YamlProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Set;

public class BaseValidatorImpl
implements BaseValidator {
    private final String project;

    public BaseValidatorImpl(String project) {
        this.project = project;
    }

    public static ValidatorFactory factory() {
        return new ValidatorFactory(){

            @Override
            public BaseValidator forProjectOnly(String project) {
                return new BaseValidatorImpl(project);
            }

            @Override
            public BaseValidator create() {
                return new BaseValidatorImpl(null);
            }
        };
    }

    public PoliciesValidation validateYamlPolicy(String ident, String text) throws IOException {
        ValidationSet validation = new ValidationSet();
        CacheableYamlSource source = YamlProvider.sourceFromString(ident, text, new Date(), validation);
        PolicyCollection policies = YamlProvider.policiesFromSource(source, this.getForcedContext(), validation);
        validation.complete();
        return new PoliciesValidation((Validation)validation, policies);
    }

    @Override
    public RuleSetValidation<PolicyCollection> validateYamlPolicy(String ident, File source) throws IOException {
        ValidationSet validation = new ValidationSet();
        PolicyCollection policies = null;
        try (FileInputStream stream = new FileInputStream(source);){
            policies = YamlProvider.policiesFromSource(YamlProvider.sourceFromStream(ident, stream, new Date(), validation), this.getForcedContext(), validation);
        }
        validation.complete();
        return new PoliciesValidation((Validation)validation, policies);
    }

    private Set<Attribute> getForcedContext() {
        return this.project != null ? AuthorizationUtil.projectContext((String)this.project) : null;
    }

    public PoliciesValidation validateYamlPolicy(File file) throws IOException {
        ValidationSet validation = new ValidationSet();
        PolicyCollection policies = YamlProvider.policiesFromSource(YamlProvider.sourceFromFile(file, validation), this.getForcedContext(), validation);
        validation.complete();
        return new PoliciesValidation((Validation)validation, policies);
    }
}

