/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.ProviderService;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.workflow.EngineWorkflowExecutor;
import com.dtolabs.rundeck.core.execution.workflow.NodeFirstWorkflowExecutor;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutor;
import com.dtolabs.rundeck.core.plugins.BaseProviderRegistryService;
import com.dtolabs.rundeck.core.plugins.ChainedProviderService;
import com.dtolabs.rundeck.core.plugins.PluggableProviderService;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ServiceFactory;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableService;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableServiceUtil;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkflowExecutionService
extends ChainedProviderService<WorkflowExecutor>
implements DescribableService,
PluggableProviderService<WorkflowExecutor> {
    private static final String SERVICE_NAME = "WorkflowExecution";
    private List<ProviderService<WorkflowExecutor>> serviceList = new ArrayList<ProviderService<WorkflowExecutor>>();
    private final Map<String, Class<? extends WorkflowExecutor>> registry = new HashMap<String, Class<? extends WorkflowExecutor>>();

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    WorkflowExecutionService(Framework framework) {
        this.registry.put("node-first", NodeFirstWorkflowExecutor.class);
        this.registry.put("step-first", EngineWorkflowExecutor.class);
        this.registry.put("parallel", EngineWorkflowExecutor.class);
        BaseProviderRegistryService primaryService = ServiceFactory.builtinService(framework, SERVICE_NAME, this.registry);
        this.serviceList.add(primaryService);
    }

    @Override
    protected List<ProviderService<WorkflowExecutor>> getServiceList() {
        return this.serviceList;
    }

    public static WorkflowExecutionService getInstanceForFramework(Framework framework) {
        if (null == framework.getService(SERVICE_NAME)) {
            WorkflowExecutionService service = new WorkflowExecutionService(framework);
            framework.setService(SERVICE_NAME, service);
            return service;
        }
        return (WorkflowExecutionService)framework.getService(SERVICE_NAME);
    }

    public WorkflowExecutor getExecutorForItem(WorkflowExecutionItem workflow) throws ExecutionServiceException {
        String strategy = workflow.getWorkflow().getStrategy();
        if (this.registry.containsKey(strategy)) {
            return (WorkflowExecutor)this.providerOfType(strategy);
        }
        return (WorkflowExecutor)this.providerOfType("step-first");
    }

    @Override
    public List<Description> listDescriptions() {
        return DescribableServiceUtil.listDescriptions(this);
    }

    @Override
    public List<ProviderIdent> listDescribableProviders() {
        return DescribableServiceUtil.listDescribableProviders(this);
    }
}

