/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.Condition;
import com.dtolabs.rundeck.core.rules.NumericCondition;
import com.dtolabs.rundeck.core.rules.StateObj;

public class NumericEqualsCondition
implements Condition {
    private String key;
    private String value;
    final double THRESHOLD = 1.0E-5;

    public NumericEqualsCondition(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public boolean test(StateObj input) {
        String anObject = input.getState().get(this.key);
        if (this.value == null) {
            return false;
        }
        Float fValue = NumericCondition.extractFloat(this.value);
        Float fObject = NumericCondition.extractFloat(anObject);
        return (double)Math.abs(fValue.floatValue() - fObject.floatValue()) < 1.0E-5;
    }

    public String toString() {
        return "(" + this.value + " == '" + this.key + '\'' + ")";
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }
}

