/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.MutableStateObj;
import com.dtolabs.rundeck.core.rules.RuleEngine;
import com.dtolabs.rundeck.core.rules.StateObj;
import com.dtolabs.rundeck.core.rules.WorkflowEngineOperationsProcessor;
import com.dtolabs.rundeck.core.rules.WorkflowSystem;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEvent;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEventListener;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEventType;
import com.dtolabs.rundeck.core.rules.Workflows;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class WorkflowEngine
implements WorkflowSystem {
    static Logger logger = Logger.getLogger((String)WorkflowEngine.class.getName());
    private final MutableStateObj state;
    private final RuleEngine engine;
    private final ListeningExecutorService executorService;
    private final ListeningExecutorService manager;
    private WorkflowSystemEventListener listener;
    private volatile boolean interrupted;

    public WorkflowEngine(RuleEngine engine, MutableStateObj state, ExecutorService executor) {
        this.engine = engine;
        this.state = state;
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.manager = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    }

    MutableStateObj getState() {
        return this.state;
    }

    RuleEngine getRuleEngine() {
        return this.engine;
    }

    public <DAT, RES extends WorkflowSystem.OperationCompleted<DAT>, OP extends WorkflowSystem.Operation<DAT, RES>> Set<WorkflowSystem.OperationResult<DAT, RES, OP>> processOperations(Set<OP> operations, WorkflowSystem.SharedData<DAT> sharedData) {
        WorkflowEngineOperationsProcessor processor = new WorkflowEngineOperationsProcessor(this, operations, sharedData, this.executorService, this.manager);
        processor.beginProcessing();
        Set results = processor.getResults();
        this.interrupted = processor.isInterrupted();
        this.event(WorkflowSystemEventType.WillShutdown, String.format("Workflow engine shutting down (interrupted? %s)", this.interrupted));
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5L, TimeUnit.MINUTES)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        this.manager.shutdown();
        try {
            if (!this.manager.awaitTermination(5L, TimeUnit.MINUTES)) {
                this.manager.shutdownNow();
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        if (!processor.getPending().isEmpty()) {
            this.event(WorkflowSystemEventType.IncompleteOperations, String.format("Some operations were not run: %d", processor.getPending().size()), processor.getPending());
        }
        this.event(WorkflowSystemEventType.Complete, String.format("Workflow complete: %s", results));
        return results;
    }

    void eventLoopProgress(int origPendingCount, int skipcount, int toruncount, int pendingcount) {
        this.event(WorkflowSystemEventType.LoopProgress, String.format("Pending(%d) => run(%d), skip(%d), remain(%d)", origPendingCount, toruncount - skipcount, skipcount, pendingcount));
    }

    static <T> WorkflowSystem.OperationCompleted<T> dummyResult(final StateObj state) {
        return new WorkflowSystem.OperationCompleted<T>(){

            @Override
            public StateObj getNewState() {
                return state;
            }

            @Override
            public T getResult() {
                return null;
            }
        };
    }

    void event(WorkflowSystemEventType endOfChanges, String message) {
        this.event(endOfChanges, message, null);
    }

    void event(WorkflowSystemEventType eventType, String message, Object data) {
        this.event(Event.with(eventType, message, data));
    }

    private void event(WorkflowSystemEvent event) {
        if (null != this.listener) {
            this.listener.onEvent(event);
        }
    }

    protected boolean isWorkflowEndState(MutableStateObj state) {
        return state.hasState(Workflows.getWorkflowEndState());
    }

    public WorkflowSystemEventListener getListener() {
        return this.listener;
    }

    public void setListener(WorkflowSystemEventListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    private Map<String, String> map(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        return map;
    }

    static class WResult<D, T extends WorkflowSystem.OperationCompleted<D>, X extends WorkflowSystem.Operation<D, T>>
    implements WorkflowSystem.OperationResult<D, T, X> {
        private final X operation;
        final Throwable throwable;
        final T success;

        WResult(X operation, Throwable throwable) {
            this.operation = operation;
            this.throwable = throwable;
            this.success = null;
        }

        WResult(X operation, T success) {
            this.operation = operation;
            this.success = success;
            this.throwable = null;
        }

        @Override
        public Throwable getFailure() {
            return this.throwable;
        }

        @Override
        public T getSuccess() {
            return this.success;
        }

        @Override
        public X getOperation() {
            return this.operation;
        }

        public String toString() {
            return this.operation + ": " + (null != this.success ? this.success : (null != this.throwable ? this.throwable.getClass().getSimpleName() : "?"));
        }
    }

    static class Event
    implements WorkflowSystemEvent {
        private WorkflowSystemEventType eventType;
        private String message;
        private Object data;

        Event(WorkflowSystemEventType eventType, String message, Object data) {
            this.eventType = eventType;
            this.message = message;
            this.data = data;
        }

        static Event with(WorkflowSystemEventType type, String message) {
            return new Event(type, message, null);
        }

        static Event with(WorkflowSystemEventType type, String message, Object data) {
            return new Event(type, message, data);
        }

        @Override
        public WorkflowSystemEventType getEventType() {
            return this.eventType;
        }

        public void setEventType(WorkflowSystemEventType eventType) {
            this.eventType = eventType;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }
    }

    static class Sleeper {
        private long orig = 250L;
        private long mult = 2L;
        private long max = 5000L;
        private long time = this.orig;
        private TimeUnit unit = TimeUnit.MILLISECONDS;

        Sleeper() {
        }

        long time() {
            return this.time;
        }

        void backoff() {
            this.time = Math.min(this.time * this.mult, this.max);
        }

        void reset() {
            this.time = this.orig;
        }

        TimeUnit unit() {
            return this.unit;
        }
    }
}

