/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.storage;

import com.dtolabs.rundeck.core.storage.ResourceMeta;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.Resource;
import org.rundeck.storage.conf.BaseListener;

public class StorageLogger
extends BaseListener<ResourceMeta> {
    private Logger logger;

    public StorageLogger(Logger logger) {
        this.logger = logger;
    }

    public StorageLogger(String loggerName) {
        this.logger = Logger.getLogger((String)loggerName);
    }

    public void didGetResource(Path path, Resource<ResourceMeta> resource) {
        this.log(path, "get", false, ((ResourceMeta)resource.getContents()).getMeta(), null);
    }

    protected void log(Path path, String action, boolean dir, Map<String, String> meta, String status) {
        MDC.put((String)"path", (Object)path.toString());
        MDC.put((String)"action", (Object)action);
        String metastring = null != meta ? meta.toString() : "-";
        MDC.put((String)"metadata", (Object)metastring);
        String type = dir ? "directory" : "file";
        MDC.put((String)"type", (Object)type);
        String statusString = null != status ? status : "-";
        MDC.put((String)"status", (Object)statusString);
        this.logger.info((Object)(action + ":[" + type + "]:" + String.valueOf(path) + ":" + (dir ? "" : metastring) + ": " + statusString));
        MDC.clear();
    }

    public void didGetPath(Path path, Resource<ResourceMeta> resource) {
        this.log(path, "get", resource.getContents() == null, null, null);
    }

    public void didDeleteResource(Path path, boolean success) {
        this.log(path, "delete", false, null, success ? "success" : "failed");
    }

    public void didCreateResource(Path path, ResourceMeta content, Resource<ResourceMeta> contents) {
        this.log(path, "create", false, content.getMeta(), null);
    }

    public void didUpdateResource(Path path, ResourceMeta content, Resource<ResourceMeta> contents) {
        this.log(path, "update", false, content.getMeta(), null);
    }
}

