package org.ryoframework.core.domain.entities

import org.ryoframework.core.domain.support.EListeners
import java.io.Serializable
import javax.persistence.EntityListeners
import javax.persistence.MappedSuperclass

@MappedSuperclass
@EntityListeners(EListeners::class)
abstract class AbstractEntity<E : Serializable> : IEntity<E> {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is AbstractEntity<*>) return false

        if (id != other.id) return false

        return true
    }

    override fun hashCode(): Int {
        return id?.hashCode() ?: 0
    }

}
