package org.ryoframework.core.domain.entities

import java.io.Serializable
import java.util.*
import javax.persistence.Id
import javax.persistence.MappedSuperclass
import javax.persistence.Version

@MappedSuperclass
abstract class AuditedEntity<E : Serializable> : AbstractEntity<E>(), ICreatedAt, IUpdatedAt {

    @Id
    override var id: E? = null

    override var createdAt: Date? = null

    override var updatedAt: Date? = null

    @Version
    private var _version: Long = 0
}
