package org.ryoframework.core.domain.entities

import java.io.Serializable
import java.util.*
import javax.persistence.Id
import javax.persistence.MappedSuperclass
import javax.persistence.Version


@MappedSuperclass
abstract class BaseEntity<E : Serializable> : AbstractEntity<E>(), ICreatedAt {

    @Id
    override var id: E? = null

    override var createdAt: Date? = null

    @Version
    private var _version: Long = 0


}
