package org.ryoframework.core.domain.services

abstract class DomainService {

    fun isValid(bean: Any) = ServiceSupport.isValid(bean)

    fun validate(bean: String?, details: Pair<String, String>) {
        if (bean.isNullOrBlank()) {
            throw DomainError(details)
        }
    }

    fun validate(bean: Any, details: Pair<String, String>) = ServiceSupport.validate(bean, details)

    fun validate(bean: Any, code: String, message: String) = ServiceSupport.validate(bean, code, message)

}
