package org.ryoframework.core.domain.services;

import javax.validation.Validation

internal object ServiceSupport {

    private val validator = Validation.buildDefaultValidatorFactory().validator!!

    @JvmStatic
    fun isValid(bean: Any): Boolean {
        val violations = validator.validate(bean)
        return violations.isEmpty()
    }

    @JvmStatic
    fun validate(bean: Any?, details: Pair<String, String>) {
        if (bean!=null && !isValid(bean)) throw DomainError(details)
    }

    @JvmStatic
    fun validateRequired(bean: Any, details: Pair<String, String>) {
        if (!isValid(bean)) throw DomainError(details)
    }

    @JvmStatic
    @JvmOverloads
    fun validate(bean: Any, code: String, message: String = code) {
        if (!isValid(bean)) throw DomainError(code, message)
    }

}
