package org.ryoframework.core.domain.support;

import javax.validation.ConstraintViolation
import javax.validation.Validation

object BeanSupport {

    private val validator = Validation.buildDefaultValidatorFactory().validator!!

    @JvmStatic
    fun isValid(bean: Any): Boolean {
        val violations = validator.validate(bean)
        return violations.isEmpty()
    }

    @JvmStatic
    fun validate(bean: Any?, error: Throwable) {
        if (bean != null && !isValid(bean)) throw error
    }

    @JvmStatic
    fun validate(bean: Any): Set<ConstraintViolation<Any>> {
        return validator.validate(bean).orEmpty()
    }

}
