package org.ryoframework.core.domain.support

import org.joda.time.DateTime
import org.joda.time.DateTimeConstants
import org.joda.time.Seconds
import java.text.SimpleDateFormat
import java.util.*

object DateUtil {


    const val YYYY_MM_DD = "yyyy-MM-dd"
    const val YYYY_MM_DD_HH_mm = "yyyy-MM-dd HH:mm"

    private var parser = com.joestelmach.natty.Parser()

    @JvmStatic
    fun parse(input: String): Date {
        val d = parser.parse(input)
        return d.first().dates.first()
    }

    @JvmStatic
    fun format(date:Date?, format:String = YYYY_MM_DD): String? {
        if (date==null) return null
        return SimpleDateFormat(format).format(date)
    }

    @JvmStatic
    fun isNowOrLater(date: Date): Boolean {
        val dt = DateTime(date)
        if (dt.isAfterNow || dt.isEqualNow || dt.isAfter( DateTime.now().minusSeconds(30) )) {
            return true
        }
        return false
    }

    @JvmStatic
    fun isBeforeMonths(date: Date, months:Int) = DateTime(date).isBefore( DateTime.now().plusMonths(months) )

    @JvmStatic
    fun isBeforeNow(date: Date) = DateTime(date).isBeforeNow

    @JvmStatic
    fun getYear(date: Date) = Calendar.getInstance().apply { time = date }.get(Calendar.YEAR)

    @JvmStatic
    fun getMonth(date: Date) = Calendar.getInstance().apply { time = date }.get(Calendar.MONTH)

    @JvmStatic
    fun getDayOfMonth(date: Date) = Calendar.getInstance().apply { time = date }.get(Calendar.DAY_OF_MONTH)

    @JvmStatic
    fun getHour(date: Date) = Calendar.getInstance().apply { time = date }.get(Calendar.HOUR_OF_DAY)

    @JvmStatic
    fun getMinute(date: Date) = Calendar.getInstance().apply { time = date }.get(Calendar.MINUTE)

    @JvmStatic
    fun plusMonths(date: Date, months: Int) = DateTime(date).plusMonths(months).toDate()

    @JvmStatic
    fun plusDays(date: Date, days: Int) = DateTime(date).plusDays(days).toDate()

    @JvmStatic
    fun plusWeeks(date: Date, weeks: Int) = DateTime(date).withDayOfWeek(DateTimeConstants.MONDAY).plusWeeks(weeks).toDate()

    @JvmStatic
    fun plusMinutes(date: Date, minutes: Int) = DateTime(date).withSecondOfMinute(0).plusMinutes(minutes).toDate()

    @JvmStatic
    fun secondsBetween(date1: Date, date2: Date): Int = Seconds.secondsBetween(DateTime(date1), DateTime(date2)).seconds
}
