package org.ryoframework.core.domain.support

import org.ryoframework.core.domain.entities.ValidationException
import org.ryoframework.core.domain.entities.ICreatedAt
import org.ryoframework.core.domain.entities.IEntity
import org.ryoframework.core.domain.entities.IUpdatedAt
import java.util.*
import javax.persistence.PrePersist
import javax.persistence.PreUpdate

class EListeners {

    private fun validate(model: IEntity<*>) {
        val errors = BeanSupport.validate(model)
        if (!errors.isNullOrEmpty() && errors.isNotEmpty()) {
            val error = ValidationException(model.javaClass.simpleName, errors.map {
                it.propertyPath.first().name to it.message
            }.toMap())
            throw error
        }
    }

    @PrePersist
    fun prePersist(model: IEntity<*>) {
        if (model is ICreatedAt) {
            model.createdAt = Date()
        }
        validate(model)
    }

    @PreUpdate
    fun preUpdate(model: IEntity<*>) {
        if (model is IUpdatedAt) {
            model.updatedAt = Date()
        }
        validate(model)
    }

}
