package org.ryoframework.core.domain.support

import com.fasterxml.uuid.Generators
import java.nio.ByteBuffer
import java.util.*


@Suppress("unused")
object GUID {

    @JvmStatic
    fun generate() = Generators.randomBasedGenerator().generate()!!

    @JvmStatic
    fun generateString(keepDash: Boolean = true): String {
        val uuid = generate().toString()
        if (!keepDash) return uuid.replace("-", "")
        return uuid
    }

    @JvmStatic
    fun shorten(prefix: String = "", uuid: UUID = generate()): String {
        val byteBuffer = ByteBuffer.allocate(16)
        byteBuffer.putLong(uuid.mostSignificantBits)
        byteBuffer.putLong(uuid.leastSignificantBits)
        val result = Base64.getEncoder().withoutPadding().encodeToString(byteBuffer.array()).replace("/", "_").replace("\\+", "-")
        if (prefix.isNotBlank()) return "$prefix$result"
        return result
    }


}
