package org.ryoframework.core.domain.support


object StringUtil {

    @JvmStatic
    fun isInt(s: String) = try {
        s.toInt().toString() == s
    } catch (ignore: Throwable) {
        false
    }

    @JvmStatic
    fun isLong(s: String) = try {
        s.toLong().toString() == s
    } catch (ignore: Throwable) {
        false
    }

    @JvmStatic
    fun countChar(s: String, char: Char): Int {
        var count = 0
        s.forEach {
            if (it == char) count++
        }
        return count
    }

    @JvmStatic
	fun camelToSnakeCase(input:String): String {
		val regex = "([a-z0-9])([A-Z]+)"
		val replacement = "$1_$2"
		return input.replace(Regex("\\s+"), "").replace(regex.toRegex(), replacement).toLowerCase()
	}

    @JvmStatic
    fun removeSpaces(input:String) = input.replace(Regex("\\s"), "")


}
