/*
 * Decompiled with CFR 0.152.
 */
package org.ryoframework.core.domain.support;

import com.joestelmach.natty.DateGroup;
import com.joestelmach.natty.Parser;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\b\u001a\u00020\u0004H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fH\u0007J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J \u0010\u0018\u001a\n \u0019*\u0004\u0018\u00010\n0\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\fH\u0007J \u0010\u001b\u001a\n \u0019*\u0004\u0018\u00010\n0\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\fH\u0007J \u0010\u001d\u001a\n \u0019*\u0004\u0018\u00010\n0\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fH\u0007J \u0010\u001e\u001a\n \u0019*\u0004\u0018\u00010\n0\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\fH\u0007J\u0018\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/ryoframework/core/domain/support/DateUtil;", "", "()V", "YYYY_MM_DD", "", "YYYY_MM_DD_HH_mm", "parser", "Lcom/joestelmach/natty/Parser;", "format", "date", "Ljava/util/Date;", "getDayOfMonth", "", "getHour", "getMinute", "getMonth", "getYear", "isBeforeMonths", "", "months", "isBeforeNow", "isNowOrLater", "parse", "input", "plusDays", "kotlin.jvm.PlatformType", "days", "plusMinutes", "minutes", "plusMonths", "plusWeeks", "weeks", "secondsBetween", "date1", "date2", "ryo-domain"})
public final class DateUtil {
    @NotNull
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    @NotNull
    public static final String YYYY_MM_DD_HH_mm = "yyyy-MM-dd HH:mm";
    private static Parser parser;
    public static final DateUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final Date parse(@NotNull String input) {
        List d;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        List list = d = parser.parse(input);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"d");
        Object object = CollectionsKt.first((List)list);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"d.first()");
        List list2 = ((DateGroup)object).getDates();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"d.first().dates");
        Object object2 = CollectionsKt.first((List)list2);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"d.first().dates.first()");
        return (Date)object2;
    }

    @JvmStatic
    @Nullable
    public static final String format(@Nullable Date date, @NotNull String format) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    @JvmStatic
    @Nullable
    public static /* synthetic */ String format$default(Date date, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = YYYY_MM_DD;
        }
        return DateUtil.format(date, string);
    }

    @JvmStatic
    public static final boolean isNowOrLater(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        DateTime dt = new DateTime((Object)date);
        return dt.isAfterNow() || dt.isEqualNow() || dt.isAfter((ReadableInstant)DateTime.now().minusSeconds(30));
    }

    @JvmStatic
    public static final boolean isBeforeMonths(@NotNull Date date, int months) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        return new DateTime((Object)date).isBefore((ReadableInstant)DateTime.now().plusMonths(months));
    }

    @JvmStatic
    public static final boolean isBeforeNow(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        return new DateTime((Object)date).isBeforeNow();
    }

    @JvmStatic
    public static final int getYear(@NotNull Date date) {
        Calendar calendar;
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Calendar $receiver = calendar = Calendar.getInstance();
        $receiver.setTime(date);
        return calendar.get(1);
    }

    @JvmStatic
    public static final int getMonth(@NotNull Date date) {
        Calendar calendar;
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Calendar $receiver = calendar = Calendar.getInstance();
        $receiver.setTime(date);
        return calendar.get(2);
    }

    @JvmStatic
    public static final int getDayOfMonth(@NotNull Date date) {
        Calendar calendar;
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Calendar $receiver = calendar = Calendar.getInstance();
        $receiver.setTime(date);
        return calendar.get(5);
    }

    @JvmStatic
    public static final int getHour(@NotNull Date date) {
        Calendar calendar;
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Calendar $receiver = calendar = Calendar.getInstance();
        $receiver.setTime(date);
        return calendar.get(11);
    }

    @JvmStatic
    public static final int getMinute(@NotNull Date date) {
        Calendar calendar;
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Calendar $receiver = calendar = Calendar.getInstance();
        $receiver.setTime(date);
        return calendar.get(12);
    }

    @JvmStatic
    public static final Date plusMonths(@NotNull Date date, int months) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        return new DateTime((Object)date).plusMonths(months).toDate();
    }

    @JvmStatic
    public static final Date plusDays(@NotNull Date date, int days) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        return new DateTime((Object)date).plusDays(days).toDate();
    }

    @JvmStatic
    public static final Date plusWeeks(@NotNull Date date, int weeks) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        return new DateTime((Object)date).withDayOfWeek(1).plusWeeks(weeks).toDate();
    }

    @JvmStatic
    public static final Date plusMinutes(@NotNull Date date, int minutes) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        return new DateTime((Object)date).withSecondOfMinute(0).plusMinutes(minutes).toDate();
    }

    @JvmStatic
    public static final int secondsBetween(@NotNull Date date1, @NotNull Date date2) {
        Intrinsics.checkParameterIsNotNull((Object)date1, (String)"date1");
        Intrinsics.checkParameterIsNotNull((Object)date2, (String)"date2");
        Seconds seconds = Seconds.secondsBetween((ReadableInstant)((ReadableInstant)new DateTime((Object)date1)), (ReadableInstant)((ReadableInstant)new DateTime((Object)date2)));
        Intrinsics.checkExpressionValueIsNotNull((Object)seconds, (String)"Seconds.secondsBetween(D\u2026(date1), DateTime(date2))");
        return seconds.getSeconds();
    }

    private DateUtil() {
    }

    static {
        DateUtil dateUtil;
        INSTANCE = dateUtil = new DateUtil();
        parser = new Parser();
    }
}

