/*
 * Decompiled with CFR 0.152.
 */
package org.ryoframework.core.domain.support;

import com.fasterxml.uuid.Generators;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0012\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u001c\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u0004H\u0007\u00a8\u0006\f"}, d2={"Lorg/ryoframework/core/domain/support/GUID;", "", "()V", "generate", "Ljava/util/UUID;", "generateString", "", "keepDash", "", "shorten", "prefix", "uuid", "ryo-domain"})
public final class GUID {
    public static final GUID INSTANCE;

    @JvmStatic
    @NotNull
    public static final UUID generate() {
        UUID uUID = Generators.randomBasedGenerator().generate();
        if (uUID == null) {
            Intrinsics.throwNpe();
        }
        return uUID;
    }

    @JvmStatic
    @NotNull
    public static final String generateString(boolean keepDash) {
        String string = GUID.generate().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"generate().toString()");
        String uuid = string;
        if (!keepDash) {
            return StringsKt.replace$default((String)uuid, (String)"-", (String)"", (boolean)false, (int)4, null);
        }
        return uuid;
    }

    @JvmStatic
    @NotNull
    public static /* synthetic */ String generateString$default(boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return GUID.generateString(bl);
    }

    @JvmStatic
    @NotNull
    public static final String shorten(@NotNull String prefix, @NotNull UUID uuid) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        String string = Base64.getEncoder().withoutPadding().encodeToString(byteBuffer.array());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base64.getEncoder().with\u2026tring(byteBuffer.array())");
        String result = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"/", (String)"_", (boolean)false, (int)4, null), (String)"\\+", (String)"-", (boolean)false, (int)4, null);
        CharSequence charSequence = prefix;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            return prefix + result;
        }
        return result;
    }

    @JvmStatic
    @NotNull
    public static /* synthetic */ String shorten$default(String string, UUID uUID, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            uUID = GUID.generate();
        }
        return GUID.shorten(string, uUID);
    }

    private GUID() {
    }

    static {
        GUID gUID;
        INSTANCE = gUID = new GUID();
    }
}

