package org.ryoframework.gradle.plugins.coverage

import org.gradle.api.Plugin
import org.gradle.api.Project

abstract class AbstractCoveragePlugin implements Plugin<Project> {

    void apply(Project project, BigDecimal classCoverage, BigDecimal methodsCoverage, Integer complexityCoverage) {

        project.plugins.apply("jacoco")

        project.jacocoTestReport {
            reports {
                xml.enabled true
                html.enabled true
                html.destination project.file("${project.buildDir}/jacocoHtml")
            }
        }

        project.jacocoTestCoverageVerification {
            violationRules {
                rule {
                    limit {
                        minimum = classCoverage
                        counter = "CLASS" // BRANCH CLASS COMPLEXITY INSTRUCTION  LINE  METHOD
                        value = "COVEREDRATIO" // COVEREDCOUNT COVEREDRATIO  MISSEDCOUNT  MISSEDRATIO  TOTALCOUNT
                    }
                    limit {
                        minimum = methodsCoverage
                        counter = "METHOD" // BRANCH CLASS COMPLEXITY INSTRUCTION  LINE  METHOD
                        value = "COVEREDRATIO" // COVEREDCOUNT COVEREDRATIO  MISSEDCOUNT  MISSEDRATIO  TOTALCOUNT
                    }
                    /*limit {
                        maximum = complexityCoverage
                        counter = "COMPLEXITY" // BRANCH CLASS COMPLEXITY INSTRUCTION  LINE  METHOD
                        value = "TOTALCOUNT" // COVEREDCOUNT COVEREDRATIO  MISSEDCOUNT  MISSEDRATIO  TOTALCOUNT
                    }*/
                }
            }
            dependsOn("jacocoTestReport")
        }

        project.check {
            dependsOn("jacocoTestCoverageVerification")
        }
        /*
        project.jacocoTestCoverageVerification{
            dependsOn("jacocoTestReport")
        }

        return this
        */
    }

}
