package org.ryoframework.gradle.plugins.java

import org.gradle.api.Project
import org.gradle.api.tasks.compile.JavaCompile
import org.ryoframework.gradle.support.BasePlugin

public class JavaModulePlugin extends BasePlugin {

    private static String DEFAULT_JAVA_VERSION = "1.8"

    void apply(Project project) {
        super.apply(project)
        project.setProperty("sourceCompatibility", DEFAULT_JAVA_VERSION)
        project.setProperty("targetCompatibility", DEFAULT_JAVA_VERSION)
        project.afterEvaluate {
            project.compileJava.options.encoding = 'UTF-8'
            project.tasks.withType(JavaCompile) {
                options.encoding = 'UTF-8'
            }
        }
    }

}
