package org.ryoframework.gradle.plugins.micronaut

import org.gradle.api.Plugin
import org.gradle.api.Project

class MicronautKotlinPlugin implements Plugin<Project> {

    void apply(Project project) {

        project.dependencyManagement {
            imports {
                mavenBom 'io.micronaut:micronaut-bom:1.1.0'
            }
        }
        project.plugins.apply("application")
        project.plugins.apply("kotlin-kapt")
        project.plugins.apply("groovy")
        project.plugins.apply("com.github.johnrengelman.shadow")

        project.dependencies {
            kapt "javax.persistence:javax.persistence-api:2.2"
            kapt "io.micronaut:micronaut-inject-java"
            kapt "io.micronaut:micronaut-validation"
            kapt "io.micronaut.configuration:micronaut-openapi"
            kapt "io.micronaut.spring:micronaut-spring-boot-annotation"
            kapt "io.micronaut.spring:micronaut-spring-web-annotation"
            compile "io.micronaut:micronaut-runtime"

            runtime "ch.qos.logback:logback-classic:1.2.3"
            //compile "org.ryoframework.next:ryo-adapter-micronaut"
            //compile "io.micronaut:micronaut-security-jwt"
            //compile 'org.springframework.security:spring-security-crypto:5.1.5.RELEASE'

            testRuntime "com.h2database:h2:1.4.197"
            testRuntime "org.junit.jupiter:junit-jupiter-engine:5.3.0"

            testImplementation "org.junit.jupiter:junit-jupiter-api:5.3.0"
            testImplementation "io.micronaut:micronaut-inject-groovy"
            testImplementation "io.micronaut.test:micronaut-test-junit5"
            testImplementation "io.micronaut.test:micronaut-test-spock"
            testImplementation 'org.spockframework:spock-core:1.3-groovy-2.5'

            kaptTest "io.micronaut:micronaut-inject-java"
            kaptTest "io.micronaut.spring:micronaut-spring-web-annotation"
        }

        project.configurations {
            // for dependencies that are needed for development only
            developmentOnly
        }

        project.test.classpath += project.configurations.developmentOnly


        project.allOpen {
            annotation("io.micronaut.aop.Around")
        }

        project.compileKotlin {
            kotlinOptions {
                javaParameters = true
            }
        }

        project.compileTestKotlin {
            kotlinOptions {
                javaParameters = true
            }
        }

        project.test {
            useJUnitPlatform()
        }

        project.shadowJar {
            mergeServiceFiles()
        }

        project.run.classpath += project.configurations.developmentOnly
        project.run.jvmArgs('-noverify', '-XX:TieredStopAtLevel=1', '-Dcom.sun.management.jmxremote')

    }

}
