package org.ryoframework.gradle.support


import org.gradle.api.Project
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile
import org.ryoframework.gradle.model.RyoModel
import org.springframework.boot.gradle.plugin.SpringBootPlugin

abstract class BasePlugin extends PlatformPlugin {

    public static final String EXTENSION_NAME = 'ryo'

    void apply(Project project) {
        super.apply(project)
        project.plugins.apply('java')
        project.plugins.apply('java-library')
        if (!getExtension(project)) {
            project.extensions.create(EXTENSION_NAME, RyoModel)
        }
    }

    static RyoModel getExtension(Project project) {
        return (RyoModel) project.extensions.findByName(EXTENSION_NAME)
    }

    static void configureSpringDependencies(Project project) {
        project.plugins.apply("io.spring.dependency-management")

        project.dependencyManagement {
            imports {
                mavenBom SpringBootPlugin.BOM_COORDINATES
            }
        }

        /*
        String springPlatform = safeProperty(project, "springPlatform") ?: "Cairo-SR6"
        project.dependencyManagement {
            imports {
                mavenBom("io.spring.platform:platform-bom:$springPlatform") {
                    if (project.plugins.hasPlugin("kotlin")) {
                        bomProperty 'kotlin.version', project.property("kotlin.version")
                    }
                }
            }
        }

        String springCloud = safeProperty(project, "springCloudPlatform") ?: "Finchley.SR1"

        project.dependencyManagement {
            imports {
                mavenBom("io.spring.platform:platform-bom:$springPlatform") {
                    if (project.plugins.hasPlugin("kotlin")) {
                        bomProperty 'kotlin.version', project.property("kotlin.version")
                    }
                }
                // mavenBom("org.springframework.cloud:spring-cloud-starter-parent:$springCloud")
                // mavenBom("org.springframework.cloud:spring-cloud-vault-dependencies:1.1.2.RELEASE")
            }
        }
        */
        project.dependencies.add("testImplementation", "org.springframework.boot:spring-boot-starter-test")
        project.dependencies.add("testImplementation", "com.h2database:h2")
    }

    static void configureSpringBoot(Project project) {
        configureSpringDependencies(project)
        project.plugins.apply("org.springframework.boot")
        project.task("stage") {
            dependsOn "bootJar"
        }

    }

    static void configureKotlin(Project project, String defaultVersion) {
        project.plugins.apply("kotlin")
        project.plugins.apply("kotlin-allopen")
        String kotlinVersion = project.findProperty("kotlinVersion") ?: defaultVersion

        project.ext['kotlin.version'] = kotlinVersion

        project.tasks.withType(KotlinCompile) {
            kotlinOptions {
                jvmTarget = "1.8"
                suppressWarnings = true
                verbose = false
                javaParameters = true
            }
        }
        project.dependencies.add("implementation", "org.jetbrains.kotlin:kotlin-stdlib-jdk8:$kotlinVersion")
        project.dependencies.add("implementation", "org.jetbrains.kotlin:kotlin-reflect:$kotlinVersion")
        project.dependencies.add("testImplementation", "org.jetbrains.kotlin:kotlin-test-junit:$kotlinVersion")
        project.allOpen {
            annotation("org.ryoframework.commons.annotations.KotlinAllOpen")
        }
    }

}
