/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.assignment.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.assignment.api.AssignmentReferenceReckoner;
import org.sakaiproject.assignment.api.AssignmentService;
import org.sakaiproject.assignment.api.model.Assignment;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AssignmentEntity
implements Entity {
    private static final Logger log = LoggerFactory.getLogger(AssignmentEntity.class);
    private AssignmentService assignmentService;
    private EntityManager entityManager;
    private ServerConfigurationService serverConfigurationService;
    private String assignmentId;
    private Assignment assignment;
    private Reference reference;

    public void initEntity(Assignment assignment) {
        Objects.requireNonNull(assignment, "Assignment cannot be null");
        if (StringUtils.isNotBlank((CharSequence)assignment.getId())) {
            this.assignment = assignment;
            this.assignmentId = assignment.getId();
        }
        this.reference = this.entityManager.newReference(AssignmentReferenceReckoner.reckoner().assignment(assignment).reckon().getReference());
    }

    public void initEntity(String assignmentId) {
        Objects.requireNonNull(assignmentId, "Assignment id cannot be null");
        this.assignmentId = assignmentId;
        try {
            this.assignment = this.assignmentService.getAssignment(assignmentId);
        }
        catch (IdUnusedException | PermissionException e) {
            log.warn("Could not fetch assignment with id = {}", (Object)this.reference.getId(), (Object)e);
        }
        if (this.assignment == null) {
            throw new RuntimeException("Cannot instantiate AssignmentEntity without an assignment...");
        }
        this.reference = this.entityManager.newReference(AssignmentReferenceReckoner.reckoner().assignment(this.assignment).reckon().getReference());
    }

    public String getUrl() {
        return this.reference.getUrl();
    }

    public String getReference() {
        return this.reference.getReference();
    }

    public String getUrl(String rootProperty) {
        return null;
    }

    public String getReference(String rootProperty) {
        return this.getReference();
    }

    public String getId() {
        return this.reference.getId();
    }

    public String getTitle() {
        return this.assignment.getTitle();
    }

    public ResourceProperties getProperties() {
        return this.reference.getProperties();
    }

    public Element toXml(Document doc, Stack<Element> stack) {
        String xml = this.assignmentService.getXmlAssignment(this.assignment);
        Document document = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));){
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = builder.parse(in);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Could not read assignment XML input stream", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error("Could not get instance an of DocumentBuilder", (Throwable)e);
        }
        catch (SAXException e) {
            log.error("Could not parse assignment xml", (Throwable)e);
        }
        catch (IOException e) {
            log.error("IO error", (Throwable)e);
        }
        if (document != null) {
            return document.getDocumentElement();
        }
        return null;
    }

    public void setAssignmentService(AssignmentService assignmentService) {
        this.assignmentService = assignmentService;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }
}

