/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.assignment.api;

import java.io.OutputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sakaiproject.assignment.api.AssignmentConstants;
import org.sakaiproject.assignment.api.ContentReviewResult;
import org.sakaiproject.assignment.api.model.Assignment;
import org.sakaiproject.assignment.api.model.AssignmentSubmission;
import org.sakaiproject.assignment.api.model.AssignmentSubmissionSubmitter;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.user.api.User;
import org.w3c.dom.Element;

public interface AssignmentService
extends EntityProducer {
    public Entity createAssignmentEntity(String var1);

    public Entity createAssignmentEntity(Assignment var1);

    public boolean allowReceiveSubmissionNotification(String var1);

    public List<User> allowReceiveSubmissionNotificationUsers(String var1);

    public Collection<Group> getGroupsAllowRemoveAssignment(String var1);

    public boolean allowAddAssignment(String var1);

    public boolean allowUpdateAssignmentInContext(String var1);

    public boolean allowAddSiteAssignment(String var1);

    public boolean allowRemoveAssignmentInContext(String var1);

    public boolean allowAllGroups(String var1);

    public boolean allowGetAssignment(String var1);

    public Collection<Group> getGroupsAllowAddAssignment(String var1);

    public Collection<Group> getGroupsAllowUpdateAssignment(String var1);

    public Collection<Group> getGroupsAllowGradeAssignment(String var1);

    public boolean allowUpdateAssignment(String var1);

    public boolean allowRemoveAssignment(String var1);

    public boolean allowAddSubmission(String var1);

    public boolean allowAddSubmissionCheckGroups(Assignment var1);

    public List<User> allowAddSubmissionUsers(String var1);

    public List<User> allowGradeAssignmentUsers(String var1);

    public List<String> allowAddAnySubmissionUsers(String var1);

    public List<User> allowAddAssignmentUsers(String var1);

    public boolean allowGetSubmission(String var1);

    public boolean allowUpdateSubmission(String var1);

    public boolean allowRemoveSubmission(String var1);

    public boolean allowReviewService(Site var1);

    public boolean allowGradeSubmission(String var1);

    public Assignment addAssignment(String var1) throws PermissionException;

    public Assignment mergeAssignment(Element var1) throws IdInvalidException, IdUsedException, PermissionException;

    public Assignment addDuplicateAssignment(String var1, String var2) throws IdInvalidException, PermissionException, IdUsedException, IdUnusedException;

    public void deleteAssignment(Assignment var1) throws PermissionException;

    public void softDeleteAssignment(Assignment var1) throws PermissionException;

    public void deleteAssignmentAndAllReferences(Assignment var1) throws PermissionException;

    public AssignmentSubmission addSubmission(String var1, String var2) throws PermissionException;

    public AssignmentSubmission mergeSubmission(Element var1) throws IdInvalidException, IdUsedException, PermissionException;

    public void removeSubmission(AssignmentSubmission var1) throws PermissionException;

    public void updateAssignment(Assignment var1) throws PermissionException;

    public void updateSubmission(AssignmentSubmission var1) throws PermissionException;

    public Assignment getAssignment(Reference var1) throws IdUnusedException, PermissionException;

    public Assignment getAssignment(String var1) throws IdUnusedException, PermissionException;

    public AssignmentConstants.Status getAssignmentCannonicalStatus(String var1) throws IdUnusedException, PermissionException;

    public AssignmentSubmission getSubmission(String var1) throws IdUnusedException, PermissionException;

    public Collection<Assignment> getAssignmentsForContext(String var1);

    public Collection<Assignment> getDeletedAssignmentsForContext(String var1);

    public Map<Assignment, List<String>> getSubmittableAssignmentsForContext(String var1);

    public AssignmentSubmission getSubmission(String var1, User var2) throws PermissionException;

    public AssignmentSubmission getSubmission(String var1, String var2) throws PermissionException;

    @Deprecated
    public AssignmentSubmission getSubmission(List<AssignmentSubmission> var1, User var2);

    public Set<AssignmentSubmission> getSubmissions(Assignment var1);

    public String getAssignmentStatus(String var1);

    public String getSubmissionStatus(String var1);

    public List<User> getSortedGroupUsers(Group var1);

    public int countSubmissions(String var1, Boolean var2);

    public byte[] getGradesSpreadsheet(String var1) throws IdUnusedException, PermissionException;

    public void getSubmissionsZip(OutputStream var1, String var2, String var3) throws IdUnusedException, PermissionException;

    public String assignmentReference(String var1, String var2);

    public String assignmentReference(String var1);

    public String submissionReference(String var1, String var2, String var3);

    public boolean canSubmit(String var1, Assignment var2, String var3);

    public boolean canSubmit(String var1, Assignment var2);

    public Collection<Group> getSubmitterGroupList(String var1, String var2, String var3, String var4, String var5);

    public boolean getAllowSubmitByInstructor();

    public List<String> getSubmitterIdList(String var1, String var2, String var3, String var4, String var5);

    public Map<User, AssignmentSubmission> getSubmitterMap(String var1, String var2, String var3, String var4, String var5);

    public String escapeInvalidCharsEntry(String var1);

    public boolean assignmentUsesAnonymousGrading(Assignment var1);

    public Integer getScaleFactor();

    public String getDeepLinkWithPermissions(String var1, String var2, boolean var3, boolean var4, boolean var5) throws Exception;

    public String getDeepLink(String var1, String var2) throws Exception;

    public String getCsvSeparator();

    public String getXmlAssignment(Assignment var1);

    public String getGradeForUserInGradeBook(String var1, String var2);

    public String getGradeDisplay(String var1, Assignment.GradeType var2, Integer var3);

    public String getMaxPointGradeDisplay(int var1, int var2);

    public Optional<AssignmentSubmissionSubmitter> getSubmissionSubmittee(AssignmentSubmission var1);

    public Collection<User> getSubmissionSubmittersAsUsers(AssignmentSubmission var1);

    public boolean isPeerAssessmentOpen(Assignment var1);

    public boolean isPeerAssessmentPending(Assignment var1);

    public boolean isPeerAssessmentClosed(Assignment var1);

    public void resetAssignment(Assignment var1);

    public void postReviewableSubmissionAttachments(AssignmentSubmission var1);

    public String getToolTitle();

    public String getUsersLocalDateTimeString(Instant var1);

    public List<ContentReviewResult> getContentReviewResults(AssignmentSubmission var1);
}

