/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.assignment.api.model;

import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import org.sakaiproject.assignment.api.model.Assignment;
import org.sakaiproject.assignment.api.model.AssignmentSubmissionSubmitter;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="ASN_SUBMISSION")
public class AssignmentSubmission {
    @Id
    @Column(name="SUBMISSION_ID", length=36, nullable=false)
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    private String id;
    @ManyToOne
    @JoinColumn(name="ASSIGNMENT_ID")
    private Assignment assignment;
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OneToMany(mappedBy="submission", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<AssignmentSubmissionSubmitter> submitters = new HashSet<AssignmentSubmissionSubmitter>();
    @Type(type="org.sakaiproject.springframework.orm.hibernate.type.InstantType")
    @Column(name="SUBMITTED_DATE")
    private Instant dateSubmitted;
    @Type(type="org.sakaiproject.springframework.orm.hibernate.type.InstantType")
    @Column(name="RETURNED_DATE")
    private Instant dateReturned;
    @Type(type="org.sakaiproject.springframework.orm.hibernate.type.InstantType")
    @Column(name="CREATED_DATE")
    private Instant dateCreated;
    @Type(type="org.sakaiproject.springframework.orm.hibernate.type.InstantType")
    @Column(name="MODIFIED_DATE")
    private Instant dateModified;
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection
    @Column(name="ATTACHMENT", length=1024)
    @CollectionTable(name="ASN_SUBMISSION_ATTACHMENTS", joinColumns={@JoinColumn(name="SUBMISSION_ID")})
    private Set<String> attachments = new HashSet<String>();
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection
    @Column(name="FEEDBACK_ATTACHMENT", length=1024)
    @CollectionTable(name="ASN_SUBMISSION_FEEDBACK_ATTACH", joinColumns={@JoinColumn(name="SUBMISSION_ID")})
    private Set<String> feedbackAttachments = new HashSet<String>();
    @Lob
    @Column(name="TEXT", length=65535)
    private String submittedText;
    @Lob
    @Column(name="FEEDBACK_COMMENT", length=65535)
    private String feedbackComment;
    @Lob
    @Column(name="FEEDBACK_TEXT", length=65535)
    private String feedbackText;
    @Column(name="GRADE", length=32)
    private String grade;
    @Column(name="FACTOR")
    private Integer factor;
    @Column(name="SUBMITTED")
    private Boolean submitted = Boolean.FALSE;
    @Column(name="RETURNED")
    private Boolean returned = Boolean.FALSE;
    @Column(name="GRADED")
    private Boolean graded = Boolean.FALSE;
    @Column(name="GRADED_BY", length=99)
    private String gradedBy;
    @Column(name="GRADE_RELEASED")
    private Boolean gradeReleased = Boolean.FALSE;
    @Column(name="HONOR_PLEDGE")
    private Boolean honorPledge = Boolean.FALSE;
    @Column(name="HIDDEN_DUE_DATE")
    private Boolean hiddenDueDate = Boolean.FALSE;
    @Column(name="USER_SUBMISSION")
    private Boolean userSubmission = Boolean.FALSE;
    @Column(name="GROUP_ID", length=36)
    private String groupId;
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection
    @MapKeyColumn(name="NAME")
    @Lob
    @Column(name="VALUE", length=65535)
    @CollectionTable(name="ASN_SUBMISSION_PROPERTIES", joinColumns={@JoinColumn(name="SUBMISSION_ID")})
    private Map<String, String> properties = new HashMap<String, String>();

    public String getId() {
        return this.id;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    public Set<AssignmentSubmissionSubmitter> getSubmitters() {
        return this.submitters;
    }

    public Instant getDateSubmitted() {
        return this.dateSubmitted;
    }

    public Instant getDateReturned() {
        return this.dateReturned;
    }

    public Instant getDateCreated() {
        return this.dateCreated;
    }

    public Instant getDateModified() {
        return this.dateModified;
    }

    public Set<String> getAttachments() {
        return this.attachments;
    }

    public Set<String> getFeedbackAttachments() {
        return this.feedbackAttachments;
    }

    public String getSubmittedText() {
        return this.submittedText;
    }

    public String getFeedbackComment() {
        return this.feedbackComment;
    }

    public String getFeedbackText() {
        return this.feedbackText;
    }

    public String getGrade() {
        return this.grade;
    }

    public Integer getFactor() {
        return this.factor;
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public Boolean getReturned() {
        return this.returned;
    }

    public Boolean getGraded() {
        return this.graded;
    }

    public String getGradedBy() {
        return this.gradedBy;
    }

    public Boolean getGradeReleased() {
        return this.gradeReleased;
    }

    public Boolean getHonorPledge() {
        return this.honorPledge;
    }

    public Boolean getHiddenDueDate() {
        return this.hiddenDueDate;
    }

    public Boolean getUserSubmission() {
        return this.userSubmission;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAssignment(Assignment assignment) {
        this.assignment = assignment;
    }

    public void setSubmitters(Set<AssignmentSubmissionSubmitter> submitters) {
        this.submitters = submitters;
    }

    public void setDateSubmitted(Instant dateSubmitted) {
        this.dateSubmitted = dateSubmitted;
    }

    public void setDateReturned(Instant dateReturned) {
        this.dateReturned = dateReturned;
    }

    public void setDateCreated(Instant dateCreated) {
        this.dateCreated = dateCreated;
    }

    public void setDateModified(Instant dateModified) {
        this.dateModified = dateModified;
    }

    public void setAttachments(Set<String> attachments) {
        this.attachments = attachments;
    }

    public void setFeedbackAttachments(Set<String> feedbackAttachments) {
        this.feedbackAttachments = feedbackAttachments;
    }

    public void setSubmittedText(String submittedText) {
        this.submittedText = submittedText;
    }

    public void setFeedbackComment(String feedbackComment) {
        this.feedbackComment = feedbackComment;
    }

    public void setFeedbackText(String feedbackText) {
        this.feedbackText = feedbackText;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public void setFactor(Integer factor) {
        this.factor = factor;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public void setReturned(Boolean returned) {
        this.returned = returned;
    }

    public void setGraded(Boolean graded) {
        this.graded = graded;
    }

    public void setGradedBy(String gradedBy) {
        this.gradedBy = gradedBy;
    }

    public void setGradeReleased(Boolean gradeReleased) {
        this.gradeReleased = gradeReleased;
    }

    public void setHonorPledge(Boolean honorPledge) {
        this.honorPledge = honorPledge;
    }

    public void setHiddenDueDate(Boolean hiddenDueDate) {
        this.hiddenDueDate = hiddenDueDate;
    }

    public void setUserSubmission(Boolean userSubmission) {
        this.userSubmission = userSubmission;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String toString() {
        return "AssignmentSubmission(id=" + this.getId() + ", dateSubmitted=" + this.getDateSubmitted() + ", dateReturned=" + this.getDateReturned() + ", dateCreated=" + this.getDateCreated() + ", dateModified=" + this.getDateModified() + ", submittedText=" + this.getSubmittedText() + ", feedbackComment=" + this.getFeedbackComment() + ", feedbackText=" + this.getFeedbackText() + ", grade=" + this.getGrade() + ", factor=" + this.getFactor() + ", submitted=" + this.getSubmitted() + ", returned=" + this.getReturned() + ", graded=" + this.getGraded() + ", gradedBy=" + this.getGradedBy() + ", gradeReleased=" + this.getGradeReleased() + ", honorPledge=" + this.getHonorPledge() + ", hiddenDueDate=" + this.getHiddenDueDate() + ", userSubmission=" + this.getUserSubmission() + ", groupId=" + this.getGroupId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssignmentSubmission)) {
            return false;
        }
        AssignmentSubmission other = (AssignmentSubmission)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssignmentSubmission;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

