/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.assignment.api.model;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.sakaiproject.assignment.api.model.AssessorSubmissionId;
import org.sakaiproject.assignment.api.model.PeerAssessmentAttachment;
import org.sakaiproject.entity.api.Reference;

@Entity
@Table(name="ASN_PEER_ASSESSMENT_ITEM_T", indexes={@Index(name="PEER_ASSESSOR2_I", columnList="ASSIGNMENT_ID, ASSESSOR_USER_ID")})
@NamedQueries(value={@NamedQuery(name="findPeerAssessmentItemsBySubmissions", query="from PeerAssessmentItem p where p.id.submissionId in (:submissionIds) order by p.assignmentId, p.id.submissionId, p.id.assessorUserId"), @NamedQuery(name="findPeerAssessmentItemsByUserAndAssignment", query="from PeerAssessmentItem p where p.id.assessorUserId = :assessorUserId and p.assignmentId = :assignmentId order by p.assignmentId, p.id.submissionId, p.id.assessorUserId"), @NamedQuery(name="findPeerAssessmentItemsByUserAndSubmission", query="from PeerAssessmentItem p where p.id.assessorUserId = :assessorUserId and p.id.submissionId = :submissionId order by p.assignmentId, p.id.submissionId, p.id.assessorUserId"), @NamedQuery(name="findPeerAssessmentItemsBySubmissionId", query="from PeerAssessmentItem p where p.id.submissionId = :submissionId\torder by p.assignmentId, p.id.submissionId, p.id.assessorUserId"), @NamedQuery(name="findPeerAssessmentItemsByAssignmentId", query="from PeerAssessmentItem p where p.assignmentId = :assignmentId order by p.assignmentId, p.id.submissionId, p.id.assessorUserId")})
public class PeerAssessmentItem
implements Serializable {
    private static final long serialVersionUID = -8376570648172966170L;
    @EmbeddedId
    private AssessorSubmissionId id;
    @Column(name="ASSIGNMENT_ID", nullable=false)
    private String assignmentId;
    @Column(name="SCORE")
    private Integer score;
    @Lob
    @Column(name="REVIEW_COMMENT")
    private String comment;
    @Column(name="REMOVED", nullable=false)
    private Boolean removed = Boolean.FALSE;
    @Column(name="SUBMITTED", nullable=false)
    private Boolean submitted = Boolean.FALSE;
    @Transient
    private List<PeerAssessmentAttachment> attachmentList;
    @Transient
    private List<Reference> attachmentRefList;
    @Transient
    private String assessorDisplayName;
    @Transient
    private Integer scaledFactor = 10;

    @Transient
    public String getScoreDisplay() {
        return this.getScore() == null ? "" : "" + (double)this.score.intValue() / (double)this.getScaledFactor().intValue();
    }

    @Transient
    public boolean isDraft() {
        return this.submitted == false && (this.getScore() != null || this.getComment() != null && !"".equals(this.getComment().trim()));
    }

    public AssessorSubmissionId getId() {
        return this.id;
    }

    public String getAssignmentId() {
        return this.assignmentId;
    }

    public Integer getScore() {
        return this.score;
    }

    public String getComment() {
        return this.comment;
    }

    public Boolean getRemoved() {
        return this.removed;
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public List<PeerAssessmentAttachment> getAttachmentList() {
        return this.attachmentList;
    }

    public List<Reference> getAttachmentRefList() {
        return this.attachmentRefList;
    }

    public String getAssessorDisplayName() {
        return this.assessorDisplayName;
    }

    public Integer getScaledFactor() {
        return this.scaledFactor;
    }

    public void setId(AssessorSubmissionId id) {
        this.id = id;
    }

    public void setAssignmentId(String assignmentId) {
        this.assignmentId = assignmentId;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setRemoved(Boolean removed) {
        this.removed = removed;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public void setAttachmentList(List<PeerAssessmentAttachment> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public void setAttachmentRefList(List<Reference> attachmentRefList) {
        this.attachmentRefList = attachmentRefList;
    }

    public void setAssessorDisplayName(String assessorDisplayName) {
        this.assessorDisplayName = assessorDisplayName;
    }

    public void setScaledFactor(Integer scaledFactor) {
        this.scaledFactor = scaledFactor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeerAssessmentItem)) {
            return false;
        }
        PeerAssessmentItem other = (PeerAssessmentItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AssessorSubmissionId this$id = this.getId();
        AssessorSubmissionId other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$assignmentId = this.getAssignmentId();
        String other$assignmentId = other.getAssignmentId();
        if (this$assignmentId == null ? other$assignmentId != null : !this$assignmentId.equals(other$assignmentId)) {
            return false;
        }
        Integer this$score = this.getScore();
        Integer other$score = other.getScore();
        if (this$score == null ? other$score != null : !((Object)this$score).equals(other$score)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Boolean this$removed = this.getRemoved();
        Boolean other$removed = other.getRemoved();
        if (this$removed == null ? other$removed != null : !((Object)this$removed).equals(other$removed)) {
            return false;
        }
        Boolean this$submitted = this.getSubmitted();
        Boolean other$submitted = other.getSubmitted();
        if (this$submitted == null ? other$submitted != null : !((Object)this$submitted).equals(other$submitted)) {
            return false;
        }
        List<PeerAssessmentAttachment> this$attachmentList = this.getAttachmentList();
        List<PeerAssessmentAttachment> other$attachmentList = other.getAttachmentList();
        if (this$attachmentList == null ? other$attachmentList != null : !((Object)this$attachmentList).equals(other$attachmentList)) {
            return false;
        }
        List<Reference> this$attachmentRefList = this.getAttachmentRefList();
        List<Reference> other$attachmentRefList = other.getAttachmentRefList();
        if (this$attachmentRefList == null ? other$attachmentRefList != null : !((Object)this$attachmentRefList).equals(other$attachmentRefList)) {
            return false;
        }
        String this$assessorDisplayName = this.getAssessorDisplayName();
        String other$assessorDisplayName = other.getAssessorDisplayName();
        if (this$assessorDisplayName == null ? other$assessorDisplayName != null : !this$assessorDisplayName.equals(other$assessorDisplayName)) {
            return false;
        }
        Integer this$scaledFactor = this.getScaledFactor();
        Integer other$scaledFactor = other.getScaledFactor();
        return !(this$scaledFactor == null ? other$scaledFactor != null : !((Object)this$scaledFactor).equals(other$scaledFactor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PeerAssessmentItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AssessorSubmissionId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $assignmentId = this.getAssignmentId();
        result = result * 59 + ($assignmentId == null ? 43 : $assignmentId.hashCode());
        Integer $score = this.getScore();
        result = result * 59 + ($score == null ? 43 : ((Object)$score).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Boolean $removed = this.getRemoved();
        result = result * 59 + ($removed == null ? 43 : ((Object)$removed).hashCode());
        Boolean $submitted = this.getSubmitted();
        result = result * 59 + ($submitted == null ? 43 : ((Object)$submitted).hashCode());
        List<PeerAssessmentAttachment> $attachmentList = this.getAttachmentList();
        result = result * 59 + ($attachmentList == null ? 43 : ((Object)$attachmentList).hashCode());
        List<Reference> $attachmentRefList = this.getAttachmentRefList();
        result = result * 59 + ($attachmentRefList == null ? 43 : ((Object)$attachmentRefList).hashCode());
        String $assessorDisplayName = this.getAssessorDisplayName();
        result = result * 59 + ($assessorDisplayName == null ? 43 : $assessorDisplayName.hashCode());
        Integer $scaledFactor = this.getScaledFactor();
        result = result * 59 + ($scaledFactor == null ? 43 : ((Object)$scaledFactor).hashCode());
        return result;
    }

    public String toString() {
        return "PeerAssessmentItem(id=" + this.getId() + ", assignmentId=" + this.getAssignmentId() + ", score=" + this.getScore() + ", comment=" + this.getComment() + ", removed=" + this.getRemoved() + ", submitted=" + this.getSubmitted() + ", attachmentList=" + this.getAttachmentList() + ", attachmentRefList=" + this.getAttachmentRefList() + ", assessorDisplayName=" + this.getAssessorDisplayName() + ", scaledFactor=" + this.getScaledFactor() + ")";
    }
}

