/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.assignment.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.assignment.api.AssignmentReferenceReckoner;
import org.sakaiproject.assignment.api.AssignmentService;
import org.sakaiproject.assignment.api.model.Assignment;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AssignmentEntity
implements Entity {
    private static final Logger log = LoggerFactory.getLogger(AssignmentEntity.class);
    private AssignmentService assignmentService;
    private EntityManager entityManager;
    private ServerConfigurationService serverConfigurationService;
    private String assignmentId;
    private Assignment assignment;
    private Reference reference;

    public void initEntity(Assignment assignment) {
        if (assignment != null && StringUtils.isNotBlank((CharSequence)assignment.getId())) {
            this.assignment = assignment;
            this.assignmentId = assignment.getId();
            this.reference = this.entityManager.newReference(AssignmentReferenceReckoner.reckoner().assignment(assignment).reckon().getReference());
        } else {
            log.warn("Can not initialize entity with assignment {}", (Object)assignment);
        }
    }

    public void initEntity(String assignmentId) {
        if (StringUtils.isNotBlank((CharSequence)assignmentId)) {
            try {
                this.assignment = this.assignmentService.getAssignment(assignmentId);
                this.assignmentId = assignmentId;
                this.reference = this.entityManager.newReference(AssignmentReferenceReckoner.reckoner().assignment(this.assignment).reckon().getReference());
            }
            catch (Exception e) {
                log.warn("Could not initialize entity with assignment id {}", (Object)assignmentId, (Object)e);
            }
        } else {
            log.warn("Can not initialize entity with assignment id {}", (Object)assignmentId);
        }
    }

    private String getAccessPoint(boolean relative) {
        return relative ? "" : this.serverConfigurationService.getAccessUrl();
    }

    public String getUrl() {
        return this.reference != null ? this.getAccessPoint(false) + this.reference.getReference() : null;
    }

    public String getReference() {
        return this.reference != null ? this.reference.getReference() : null;
    }

    public String getUrl(String rootProperty) {
        return this.getUrl();
    }

    public String getReference(String rootProperty) {
        return this.getReference();
    }

    public String getId() {
        return this.reference != null ? this.reference.getId() : null;
    }

    public String getTitle() {
        return this.assignment != null ? this.assignment.getTitle() : null;
    }

    public ResourceProperties getProperties() {
        return this.reference != null ? this.reference.getProperties() : null;
    }

    public Element toXml(Document doc, Stack<Element> stack) {
        String xml = this.assignmentService.getXmlAssignment(this.assignment);
        Document document = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));){
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = builder.parse(in);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Could not read assignment XML input stream", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error("Could not get instance an of DocumentBuilder", (Throwable)e);
        }
        catch (SAXException e) {
            log.error("Could not parse assignment xml", (Throwable)e);
        }
        catch (IOException e) {
            log.error("IO error", (Throwable)e);
        }
        if (document != null) {
            return document.getDocumentElement();
        }
        return null;
    }

    public void setAssignmentService(AssignmentService assignmentService) {
        this.assignmentService = assignmentService;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }
}

