/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.assignment.api;

import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.assignment.api.ReferenceReckoner;
import org.sakaiproject.assignment.api.model.Assignment;
import org.sakaiproject.assignment.api.model.AssignmentSubmission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignmentReferenceReckoner {
    private static final Logger log = LoggerFactory.getLogger(AssignmentReferenceReckoner.class);

    public static AssignmentReference newAssignmentReferenceReckoner(Assignment assignment, AssignmentSubmission submission, String container, String context, String id, String reference, String subtype) {
        if (StringUtils.startsWith((CharSequence)reference, (CharSequence)"/assignment")) {
            String[] parts = StringUtils.splitPreserveAllTokens((String)reference, (String)"/");
            if (parts.length > 2) {
                if (subtype == null) {
                    subtype = parts[2];
                }
                if (parts.length > 3) {
                    if (context == null) {
                        context = parts[3];
                    }
                    if ("s".equals(subtype) && parts.length > 5) {
                        if (container == null) {
                            container = parts[4];
                        }
                        if (id == null) {
                            id = parts[5];
                        }
                    } else if (parts.length > 4 && id == null) {
                        id = parts[4];
                    }
                }
            }
        } else if (assignment != null) {
            context = assignment.getContext();
            id = assignment.getId();
            subtype = "a";
        } else if (submission != null) {
            Assignment submissionAssignment = submission.getAssignment();
            if (submissionAssignment != null) {
                context = submission.getAssignment().getContext();
                container = submission.getAssignment().getId();
                id = submission.getId();
                subtype = "s";
            } else {
                log.warn("no assignment while constructing submission reference");
            }
        }
        return new AssignmentReference(container == null ? "" : container, context == null ? "" : context, id == null ? "" : id, reference == null ? "" : reference, subtype == null ? "" : subtype);
    }

    public static AssignmentReferenceBuilder reckoner() {
        return new AssignmentReferenceBuilder();
    }

    public static class AssignmentReferenceBuilder {
        private Assignment assignment;
        private AssignmentSubmission submission;
        private String container;
        private String context;
        private String id;
        private String reference;
        private String subtype;

        AssignmentReferenceBuilder() {
        }

        public AssignmentReferenceBuilder assignment(Assignment assignment) {
            this.assignment = assignment;
            return this;
        }

        public AssignmentReferenceBuilder submission(AssignmentSubmission submission) {
            this.submission = submission;
            return this;
        }

        public AssignmentReferenceBuilder container(String container) {
            this.container = container;
            return this;
        }

        public AssignmentReferenceBuilder context(String context) {
            this.context = context;
            return this;
        }

        public AssignmentReferenceBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AssignmentReferenceBuilder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public AssignmentReferenceBuilder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        public AssignmentReference reckon() {
            return AssignmentReferenceReckoner.newAssignmentReferenceReckoner(this.assignment, this.submission, this.container, this.context, this.id, this.reference, this.subtype);
        }

        public String toString() {
            return "AssignmentReferenceReckoner.AssignmentReferenceBuilder(assignment=" + this.assignment + ", submission=" + this.submission + ", container=" + this.container + ", context=" + this.context + ", id=" + this.id + ", reference=" + this.reference + ", subtype=" + this.subtype + ")";
        }
    }

    public static final class AssignmentReference
    implements ReferenceReckoner {
        private final String type = "assignment";
        private final String container;
        private final String context;
        private final String id;
        private final String reference;
        private final String subtype;

        public String toString() {
            String reference = "/assignment";
            switch (this.subtype) {
                case "s": {
                    reference = reference + "/" + "s";
                    break;
                }
                case "grades": {
                    reference = reference + "/" + "grades";
                    break;
                }
                case "submissions": {
                    reference = reference + "/" + "submissions";
                    break;
                }
                default: {
                    reference = reference + "/" + "a";
                }
            }
            reference = reference + "/" + this.context;
            if (StringUtils.isNotBlank((CharSequence)this.id)) {
                if ("s".equals(this.subtype) && StringUtils.isNotBlank((CharSequence)this.container)) {
                    reference = reference + "/" + this.container;
                }
                reference = reference + "/" + this.id;
            }
            return reference;
        }

        @Override
        public String getReference() {
            return this.toString();
        }

        public AssignmentReference(String container, String context, String id, String reference, String subtype) {
            this.container = container;
            this.context = context;
            this.id = id;
            this.reference = reference;
            this.subtype = subtype;
        }

        public String getType() {
            return this.type;
        }

        public String getContainer() {
            return this.container;
        }

        public String getContext() {
            return this.context;
        }

        public String getId() {
            return this.id;
        }

        public String getSubtype() {
            return this.subtype;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssignmentReference)) {
                return false;
            }
            AssignmentReference other = (AssignmentReference)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$container = this.getContainer();
            String other$container = other.getContainer();
            if (this$container == null ? other$container != null : !this$container.equals(other$container)) {
                return false;
            }
            String this$context = this.getContext();
            String other$context = other.getContext();
            if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$reference = this.getReference();
            String other$reference = other.getReference();
            if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                return false;
            }
            String this$subtype = this.getSubtype();
            String other$subtype = other.getSubtype();
            return !(this$subtype == null ? other$subtype != null : !this$subtype.equals(other$subtype));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $container = this.getContainer();
            result = result * 59 + ($container == null ? 43 : $container.hashCode());
            String $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : $context.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $reference = this.getReference();
            result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
            String $subtype = this.getSubtype();
            result = result * 59 + ($subtype == null ? 43 : $subtype.hashCode());
            return result;
        }
    }
}

