/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.assignment.api;

import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.contentreview.dao.ContentReviewConstants;
import org.sakaiproject.contentreview.dao.ContentReviewItem;
import org.sakaiproject.entity.api.ResourceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentReviewResult {
    private static final Logger log = LoggerFactory.getLogger(ContentReviewResult.class);
    private ContentResource contentResource;
    private ContentReviewItem contentReviewItem;
    private String reviewReport;
    private String reviewIconCssClass;
    private String reviewError;

    public Long getStatus() {
        return this.contentReviewItem.getStatus();
    }

    public int getReviewScore() {
        if (this.contentResource == null) {
            log.debug(this + " getReviewScore() called with contentResource == null");
            return -2;
        }
        try {
            Long status = this.getStatus();
            if (status != null && (status.equals(ContentReviewConstants.CONTENT_REVIEW_NOT_SUBMITTED_CODE) || status.equals(ContentReviewConstants.CONTENT_REVIEW_SUBMITTED_AWAITING_REPORT_CODE))) {
                log.debug(this + " getReviewStatus returned a state of: " + status);
                return -2;
            }
            int score = this.contentReviewItem.getReviewScore();
            log.debug(this + " getReviewScore(ContentResource) CR returned a score of: " + score);
            return score;
        }
        catch (Exception cie) {
            log.error("No tiene scoreeee {} ", (Object)this.contentResource.getId());
            return -2;
        }
    }

    public boolean isInline() {
        ResourceProperties props = this.contentResource.getProperties();
        return "true".equals(props.getProperty("assignment_submission_attachment_is_inline"));
    }

    public ContentResource getContentResource() {
        return this.contentResource;
    }

    public ContentReviewItem getContentReviewItem() {
        return this.contentReviewItem;
    }

    public String getReviewReport() {
        return this.reviewReport;
    }

    public String getReviewIconCssClass() {
        return this.reviewIconCssClass;
    }

    public String getReviewError() {
        return this.reviewError;
    }

    public void setContentResource(ContentResource contentResource) {
        this.contentResource = contentResource;
    }

    public void setContentReviewItem(ContentReviewItem contentReviewItem) {
        this.contentReviewItem = contentReviewItem;
    }

    public void setReviewReport(String reviewReport) {
        this.reviewReport = reviewReport;
    }

    public void setReviewIconCssClass(String reviewIconCssClass) {
        this.reviewIconCssClass = reviewIconCssClass;
    }

    public void setReviewError(String reviewError) {
        this.reviewError = reviewError;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentReviewResult)) {
            return false;
        }
        ContentReviewResult other = (ContentReviewResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ContentResource this$contentResource = this.getContentResource();
        ContentResource other$contentResource = other.getContentResource();
        if (this$contentResource == null ? other$contentResource != null : !this$contentResource.equals(other$contentResource)) {
            return false;
        }
        ContentReviewItem this$contentReviewItem = this.getContentReviewItem();
        ContentReviewItem other$contentReviewItem = other.getContentReviewItem();
        if (this$contentReviewItem == null ? other$contentReviewItem != null : !this$contentReviewItem.equals(other$contentReviewItem)) {
            return false;
        }
        String this$reviewReport = this.getReviewReport();
        String other$reviewReport = other.getReviewReport();
        if (this$reviewReport == null ? other$reviewReport != null : !this$reviewReport.equals(other$reviewReport)) {
            return false;
        }
        String this$reviewIconCssClass = this.getReviewIconCssClass();
        String other$reviewIconCssClass = other.getReviewIconCssClass();
        if (this$reviewIconCssClass == null ? other$reviewIconCssClass != null : !this$reviewIconCssClass.equals(other$reviewIconCssClass)) {
            return false;
        }
        String this$reviewError = this.getReviewError();
        String other$reviewError = other.getReviewError();
        return !(this$reviewError == null ? other$reviewError != null : !this$reviewError.equals(other$reviewError));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentReviewResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContentResource $contentResource = this.getContentResource();
        result = result * 59 + ($contentResource == null ? 43 : $contentResource.hashCode());
        ContentReviewItem $contentReviewItem = this.getContentReviewItem();
        result = result * 59 + ($contentReviewItem == null ? 43 : $contentReviewItem.hashCode());
        String $reviewReport = this.getReviewReport();
        result = result * 59 + ($reviewReport == null ? 43 : $reviewReport.hashCode());
        String $reviewIconCssClass = this.getReviewIconCssClass();
        result = result * 59 + ($reviewIconCssClass == null ? 43 : $reviewIconCssClass.hashCode());
        String $reviewError = this.getReviewError();
        result = result * 59 + ($reviewError == null ? 43 : $reviewError.hashCode());
        return result;
    }

    public String toString() {
        return "ContentReviewResult(contentResource=" + this.getContentResource() + ", contentReviewItem=" + this.getContentReviewItem() + ", reviewReport=" + this.getReviewReport() + ", reviewIconCssClass=" + this.getReviewIconCssClass() + ", reviewError=" + this.getReviewError() + ")";
    }
}

