/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.assignment.api.model;

import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import org.sakaiproject.assignment.api.model.AssignmentSubmission;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="ASN_ASSIGNMENT", indexes={@Index(name="IDX_ASN_ASSIGNMENT_CONTEXT", columnList="CONTEXT")})
public class Assignment {
    @Id
    @Column(name="ASSIGNMENT_ID", length=36, nullable=false)
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    private String id;
    @Column(name="TITLE")
    private String title;
    @Lob
    @Column(name="INSTRUCTIONS", length=65535)
    private String instructions;
    @Column(name="CONTEXT", length=99, nullable=false)
    private String context;
    @Column(name="SECTION")
    private String section;
    @Type(type="org.sakaiproject.springframework.orm.hibernate.type.InstantType")
    @Column(name="CREATED_DATE", nullable=false)
    private Instant dateCreated;
    @Type(type="org.sakaiproject.springframework.orm.hibernate.type.InstantType")
    @Column(name="MODIFIED_DATE")
    private Instant dateModified;
    @Type(type="org.sakaiproject.springframework.orm.hibernate.type.InstantType")
    @Column(name="VISIBLE_DATE")
    private Instant visibleDate;
    @Type(type="org.sakaiproject.springframework.orm.hibernate.type.InstantType")
    @Column(name="OPEN_DATE")
    private Instant openDate;
    @Type(type="org.sakaiproject.springframework.orm.hibernate.type.InstantType")
    @Column(name="DUE_DATE")
    private Instant dueDate;
    @Type(type="org.sakaiproject.springframework.orm.hibernate.type.InstantType")
    @Column(name="CLOSE_DATE")
    private Instant closeDate;
    @Type(type="org.sakaiproject.springframework.orm.hibernate.type.InstantType")
    @Column(name="DROP_DEAD_DATE")
    private Instant dropDeadDate;
    @Column(name="MODIFIER", length=99)
    private String modifier;
    @Column(name="AUTHOR", length=99)
    private String author;
    @Column(name="DRAFT", nullable=false)
    private Boolean draft = Boolean.FALSE;
    @Column(name="DELETED")
    private Boolean deleted = Boolean.FALSE;
    @Column(name="HIDE_DUE_DATE")
    private Boolean hideDueDate = Boolean.FALSE;
    @Column(name="IS_GROUP")
    private Boolean isGroup = Boolean.FALSE;
    @Column(name="POSITION")
    private Integer position;
    @OneToMany(mappedBy="assignment", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<AssignmentSubmission> submissions = new HashSet<AssignmentSubmission>();
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection
    @MapKeyColumn(name="NAME")
    @Lob
    @Column(name="VALUE", length=65535)
    @CollectionTable(name="ASN_ASSIGNMENT_PROPERTIES", joinColumns={@JoinColumn(name="ASSIGNMENT_ID")})
    @Fetch(value=FetchMode.SUBSELECT)
    private Map<String, String> properties = new HashMap<String, String>();
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection
    @CollectionTable(name="ASN_ASSIGNMENT_GROUPS", joinColumns={@JoinColumn(name="ASSIGNMENT_ID")}, indexes={@Index(columnList="ASSIGNMENT_ID")})
    @Fetch(value=FetchMode.SUBSELECT)
    @Column(name="GROUP_ID")
    private Set<String> groups = new HashSet<String>();
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection
    @CollectionTable(name="ASN_ASSIGNMENT_ATTACHMENTS", joinColumns={@JoinColumn(name="ASSIGNMENT_ID")}, indexes={@Index(columnList="ASSIGNMENT_ID")})
    @Fetch(value=FetchMode.SUBSELECT)
    @Column(name="ATTACHMENT", length=1024)
    private Set<String> attachments = new HashSet<String>();
    @Enumerated(value=EnumType.STRING)
    @Column(name="ACCESS_TYPE", nullable=false)
    private Access typeOfAccess = Access.SITE;
    @Column(name="HONOR_PLEDGE")
    private Boolean honorPledge = Boolean.FALSE;
    @Enumerated
    @Column(name="SUBMISSION_TYPE")
    private SubmissionType typeOfSubmission = SubmissionType.ASSIGNMENT_SUBMISSION_TYPE_NONE;
    @Enumerated
    @Column(name="GRADE_TYPE")
    private GradeType typeOfGrade = GradeType.GRADE_TYPE_NONE;
    @Column(name="MAX_GRADE_POINT")
    private Integer maxGradePoint;
    @Column(name="SCALE_FACTOR")
    private Integer scaleFactor;
    @Column(name="INDIVIDUALLY_GRADED")
    private Boolean individuallyGraded;
    @Column(name="RELEASE_GRADES")
    private Boolean releaseGrades = Boolean.FALSE;
    @Column(name="ALLOW_ATTACHMENTS")
    private Boolean allowAttachments;
    @Column(name="ALLOW_PEER_ASSESSMENT")
    private Boolean allowPeerAssessment = Boolean.FALSE;
    @Type(type="org.sakaiproject.springframework.orm.hibernate.type.InstantType")
    @Column(name="PEER_ASSESSMENT_PERIOD_DATE")
    private Instant peerAssessmentPeriodDate;
    @Column(name="PEER_ASSESSMENT_ANON_EVAL")
    private Boolean peerAssessmentAnonEval;
    @Column(name="PEER_ASSESSMENT_STUDENT_REVIEW")
    private Boolean peerAssessmentStudentReview = Boolean.FALSE;
    @Column(name="PEER_ASSESSMENT_NUMBER_REVIEW")
    private Integer peerAssessmentNumberReviews;
    @Lob
    @Column(name="PEER_ASSESSMENT_INSTRUCTIONS", length=65535)
    private String peerAssessmentInstructions;
    @Column(name="CONTENT_REVIEW")
    private Boolean contentReview = Boolean.FALSE;

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public String getContext() {
        return this.context;
    }

    public String getSection() {
        return this.section;
    }

    public Instant getDateCreated() {
        return this.dateCreated;
    }

    public Instant getDateModified() {
        return this.dateModified;
    }

    public Instant getVisibleDate() {
        return this.visibleDate;
    }

    public Instant getOpenDate() {
        return this.openDate;
    }

    public Instant getDueDate() {
        return this.dueDate;
    }

    public Instant getCloseDate() {
        return this.closeDate;
    }

    public Instant getDropDeadDate() {
        return this.dropDeadDate;
    }

    public String getModifier() {
        return this.modifier;
    }

    public String getAuthor() {
        return this.author;
    }

    public Boolean getDraft() {
        return this.draft;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public Boolean getHideDueDate() {
        return this.hideDueDate;
    }

    public Boolean getIsGroup() {
        return this.isGroup;
    }

    public Integer getPosition() {
        return this.position;
    }

    public Set<AssignmentSubmission> getSubmissions() {
        return this.submissions;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public Set<String> getAttachments() {
        return this.attachments;
    }

    public Access getTypeOfAccess() {
        return this.typeOfAccess;
    }

    public Boolean getHonorPledge() {
        return this.honorPledge;
    }

    public SubmissionType getTypeOfSubmission() {
        return this.typeOfSubmission;
    }

    public GradeType getTypeOfGrade() {
        return this.typeOfGrade;
    }

    public Integer getMaxGradePoint() {
        return this.maxGradePoint;
    }

    public Integer getScaleFactor() {
        return this.scaleFactor;
    }

    public Boolean getIndividuallyGraded() {
        return this.individuallyGraded;
    }

    public Boolean getReleaseGrades() {
        return this.releaseGrades;
    }

    public Boolean getAllowAttachments() {
        return this.allowAttachments;
    }

    public Boolean getAllowPeerAssessment() {
        return this.allowPeerAssessment;
    }

    public Instant getPeerAssessmentPeriodDate() {
        return this.peerAssessmentPeriodDate;
    }

    public Boolean getPeerAssessmentAnonEval() {
        return this.peerAssessmentAnonEval;
    }

    public Boolean getPeerAssessmentStudentReview() {
        return this.peerAssessmentStudentReview;
    }

    public Integer getPeerAssessmentNumberReviews() {
        return this.peerAssessmentNumberReviews;
    }

    public String getPeerAssessmentInstructions() {
        return this.peerAssessmentInstructions;
    }

    public Boolean getContentReview() {
        return this.contentReview;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public void setDateCreated(Instant dateCreated) {
        this.dateCreated = dateCreated;
    }

    public void setDateModified(Instant dateModified) {
        this.dateModified = dateModified;
    }

    public void setVisibleDate(Instant visibleDate) {
        this.visibleDate = visibleDate;
    }

    public void setOpenDate(Instant openDate) {
        this.openDate = openDate;
    }

    public void setDueDate(Instant dueDate) {
        this.dueDate = dueDate;
    }

    public void setCloseDate(Instant closeDate) {
        this.closeDate = closeDate;
    }

    public void setDropDeadDate(Instant dropDeadDate) {
        this.dropDeadDate = dropDeadDate;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDraft(Boolean draft) {
        this.draft = draft;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public void setHideDueDate(Boolean hideDueDate) {
        this.hideDueDate = hideDueDate;
    }

    public void setIsGroup(Boolean isGroup) {
        this.isGroup = isGroup;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public void setSubmissions(Set<AssignmentSubmission> submissions) {
        this.submissions = submissions;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public void setAttachments(Set<String> attachments) {
        this.attachments = attachments;
    }

    public void setTypeOfAccess(Access typeOfAccess) {
        this.typeOfAccess = typeOfAccess;
    }

    public void setHonorPledge(Boolean honorPledge) {
        this.honorPledge = honorPledge;
    }

    public void setTypeOfSubmission(SubmissionType typeOfSubmission) {
        this.typeOfSubmission = typeOfSubmission;
    }

    public void setTypeOfGrade(GradeType typeOfGrade) {
        this.typeOfGrade = typeOfGrade;
    }

    public void setMaxGradePoint(Integer maxGradePoint) {
        this.maxGradePoint = maxGradePoint;
    }

    public void setScaleFactor(Integer scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public void setIndividuallyGraded(Boolean individuallyGraded) {
        this.individuallyGraded = individuallyGraded;
    }

    public void setReleaseGrades(Boolean releaseGrades) {
        this.releaseGrades = releaseGrades;
    }

    public void setAllowAttachments(Boolean allowAttachments) {
        this.allowAttachments = allowAttachments;
    }

    public void setAllowPeerAssessment(Boolean allowPeerAssessment) {
        this.allowPeerAssessment = allowPeerAssessment;
    }

    public void setPeerAssessmentPeriodDate(Instant peerAssessmentPeriodDate) {
        this.peerAssessmentPeriodDate = peerAssessmentPeriodDate;
    }

    public void setPeerAssessmentAnonEval(Boolean peerAssessmentAnonEval) {
        this.peerAssessmentAnonEval = peerAssessmentAnonEval;
    }

    public void setPeerAssessmentStudentReview(Boolean peerAssessmentStudentReview) {
        this.peerAssessmentStudentReview = peerAssessmentStudentReview;
    }

    public void setPeerAssessmentNumberReviews(Integer peerAssessmentNumberReviews) {
        this.peerAssessmentNumberReviews = peerAssessmentNumberReviews;
    }

    public void setPeerAssessmentInstructions(String peerAssessmentInstructions) {
        this.peerAssessmentInstructions = peerAssessmentInstructions;
    }

    public void setContentReview(Boolean contentReview) {
        this.contentReview = contentReview;
    }

    public String toString() {
        return "Assignment(id=" + this.getId() + ", title=" + this.getTitle() + ", instructions=" + this.getInstructions() + ", context=" + this.getContext() + ", section=" + this.getSection() + ", dateCreated=" + this.getDateCreated() + ", dateModified=" + this.getDateModified() + ", visibleDate=" + this.getVisibleDate() + ", openDate=" + this.getOpenDate() + ", dueDate=" + this.getDueDate() + ", closeDate=" + this.getCloseDate() + ", dropDeadDate=" + this.getDropDeadDate() + ", modifier=" + this.getModifier() + ", author=" + this.getAuthor() + ", draft=" + this.getDraft() + ", deleted=" + this.getDeleted() + ", hideDueDate=" + this.getHideDueDate() + ", isGroup=" + this.getIsGroup() + ", position=" + this.getPosition() + ", typeOfAccess=" + (Object)((Object)this.getTypeOfAccess()) + ", honorPledge=" + this.getHonorPledge() + ", typeOfSubmission=" + (Object)((Object)this.getTypeOfSubmission()) + ", typeOfGrade=" + (Object)((Object)this.getTypeOfGrade()) + ", maxGradePoint=" + this.getMaxGradePoint() + ", scaleFactor=" + this.getScaleFactor() + ", individuallyGraded=" + this.getIndividuallyGraded() + ", releaseGrades=" + this.getReleaseGrades() + ", allowAttachments=" + this.getAllowAttachments() + ", allowPeerAssessment=" + this.getAllowPeerAssessment() + ", peerAssessmentPeriodDate=" + this.getPeerAssessmentPeriodDate() + ", peerAssessmentAnonEval=" + this.getPeerAssessmentAnonEval() + ", peerAssessmentStudentReview=" + this.getPeerAssessmentStudentReview() + ", peerAssessmentNumberReviews=" + this.getPeerAssessmentNumberReviews() + ", peerAssessmentInstructions=" + this.getPeerAssessmentInstructions() + ", contentReview=" + this.getContentReview() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Assignment)) {
            return false;
        }
        Assignment other = (Assignment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Assignment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public static enum GradeType {
        GRADE_TYPE_NONE,
        UNGRADED_GRADE_TYPE,
        LETTER_GRADE_TYPE,
        SCORE_GRADE_TYPE,
        PASS_FAIL_GRADE_TYPE,
        CHECK_GRADE_TYPE;

    }

    public static enum SubmissionType {
        ASSIGNMENT_SUBMISSION_TYPE_NONE,
        TEXT_ONLY_ASSIGNMENT_SUBMISSION,
        ATTACHMENT_ONLY_ASSIGNMENT_SUBMISSION,
        TEXT_AND_ATTACHMENT_ASSIGNMENT_SUBMISSION,
        NON_ELECTRONIC_ASSIGNMENT_SUBMISSION,
        SINGLE_ATTACHMENT_SUBMISSION;

    }

    public static enum Access {
        SITE,
        GROUP;

    }
}

