/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.assignment.api.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.sakaiproject.assignment.api.model.AssignmentSubmission;

@Entity
@Table(name="ASN_SUBMISSION_SUBMITTER", uniqueConstraints={@UniqueConstraint(columnNames={"SUBMISSION_ID", "SUBMITTER"})}, indexes={@Index(columnList="SUBMITTER")})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
public class AssignmentSubmissionSubmitter {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="assignment_submission_submitters_sequence")
    @SequenceGenerator(name="assignment_submission_submitters_sequence", sequenceName="ASN_SUBMISSION_SUBMITTERS_S")
    private Long id;
    @ManyToOne
    @JoinColumn(name="SUBMISSION_ID", nullable=false)
    @JsonBackReference
    private AssignmentSubmission submission;
    @Column(name="SUBMITTER", length=99, nullable=false)
    private String submitter;
    @Column(name="SUBMITTEE", nullable=false)
    private Boolean submittee = Boolean.FALSE;
    @Column(name="GRADE", length=32)
    private String grade;
    @Lob
    @Column(name="FEEDBACK", length=65535)
    private String feedback;

    public Long getId() {
        return this.id;
    }

    public AssignmentSubmission getSubmission() {
        return this.submission;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    public Boolean getSubmittee() {
        return this.submittee;
    }

    public String getGrade() {
        return this.grade;
    }

    public String getFeedback() {
        return this.feedback;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSubmission(AssignmentSubmission submission) {
        this.submission = submission;
    }

    public void setSubmitter(String submitter) {
        this.submitter = submitter;
    }

    public void setSubmittee(Boolean submittee) {
        this.submittee = submittee;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }

    public String toString() {
        return "AssignmentSubmissionSubmitter(id=" + this.getId() + ", submitter=" + this.getSubmitter() + ", submittee=" + this.getSubmittee() + ", grade=" + this.getGrade() + ", feedback=" + this.getFeedback() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssignmentSubmissionSubmitter)) {
            return false;
        }
        AssignmentSubmissionSubmitter other = (AssignmentSubmissionSubmitter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AssignmentSubmission this$submission = this.getSubmission();
        AssignmentSubmission other$submission = other.getSubmission();
        if (this$submission == null ? other$submission != null : !((Object)this$submission).equals(other$submission)) {
            return false;
        }
        String this$submitter = this.getSubmitter();
        String other$submitter = other.getSubmitter();
        return !(this$submitter == null ? other$submitter != null : !this$submitter.equals(other$submitter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssignmentSubmissionSubmitter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AssignmentSubmission $submission = this.getSubmission();
        result = result * 59 + ($submission == null ? 43 : ((Object)$submission).hashCode());
        String $submitter = this.getSubmitter();
        result = result * 59 + ($submitter == null ? 43 : $submitter.hashCode());
        return result;
    }
}

