/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.assignment.api.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="ASN_PEER_ASSESSMENT_ATTACH_T", indexes={@Index(name="PEER_ASSESSOR_I", columnList="SUBMISSION_ID, ASSESSOR_USER_ID")})
@NamedQuery(name="findPeerAssessmentAttachmentsByUserAndSubmission", query="from PeerAssessmentAttachment p where p.assessorUserId = :assessorUserId and p.submissionId = :submissionId order by p.resourceId, p.submissionId, p.assessorUserId")
public class PeerAssessmentAttachment
implements Serializable {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="peer_assessment_attachment_sequence")
    @SequenceGenerator(name="peer_assessment_attachment_sequence", sequenceName="ASN_PEER_ATTACH_S")
    private Long id;
    @Column(name="SUBMISSION_ID", nullable=false)
    private String submissionId;
    @Column(name="ASSESSOR_USER_ID", nullable=false)
    private String assessorUserId;
    @Column(name="RESOURCE_ID", nullable=false)
    private String resourceId;

    public PeerAssessmentAttachment(String s, String a, String r) {
        this.submissionId = s;
        this.assessorUserId = a;
        this.resourceId = r;
    }

    public Long getId() {
        return this.id;
    }

    public String getSubmissionId() {
        return this.submissionId;
    }

    public String getAssessorUserId() {
        return this.assessorUserId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSubmissionId(String submissionId) {
        this.submissionId = submissionId;
    }

    public void setAssessorUserId(String assessorUserId) {
        this.assessorUserId = assessorUserId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeerAssessmentAttachment)) {
            return false;
        }
        PeerAssessmentAttachment other = (PeerAssessmentAttachment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$submissionId = this.getSubmissionId();
        String other$submissionId = other.getSubmissionId();
        if (this$submissionId == null ? other$submissionId != null : !this$submissionId.equals(other$submissionId)) {
            return false;
        }
        String this$assessorUserId = this.getAssessorUserId();
        String other$assessorUserId = other.getAssessorUserId();
        if (this$assessorUserId == null ? other$assessorUserId != null : !this$assessorUserId.equals(other$assessorUserId)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        return !(this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PeerAssessmentAttachment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $submissionId = this.getSubmissionId();
        result = result * 59 + ($submissionId == null ? 43 : $submissionId.hashCode());
        String $assessorUserId = this.getAssessorUserId();
        result = result * 59 + ($assessorUserId == null ? 43 : $assessorUserId.hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        return result;
    }

    public String toString() {
        return "PeerAssessmentAttachment(id=" + this.getId() + ", submissionId=" + this.getSubmissionId() + ", assessorUserId=" + this.getAssessorUserId() + ", resourceId=" + this.getResourceId() + ")";
    }

    public PeerAssessmentAttachment() {
    }
}

