/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.model;

import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.faces.model.SelectItem;

public class DateModel
implements Serializable {
    private static final long serialVersionUID = 3055823270695170660L;
    private static final Integer[] months;
    private static final Integer[] days;
    private static final Integer[] hours12;
    private static final Integer[] hours24;
    private static final Integer[] minutes;
    private static final Integer[] seconds;
    private static final String[] ampm;
    private Locale locale;
    private DateFormatSymbols dfs;

    public DateModel() {
        this.locale = Locale.getDefault();
        this.dfs = new DateFormatSymbols(this.locale);
    }

    public DateModel(Locale locale) {
        this.locale = locale;
        this.dfs = new DateFormatSymbols(locale);
    }

    public Integer[] getYears(int rangeBefore, int rangeAfter) {
        Calendar cal = Calendar.getInstance(this.locale);
        int currentYear = cal.get(1);
        int startYear = currentYear - rangeBefore;
        int noOfYears = rangeBefore + rangeAfter + 1;
        Integer[] years = new Integer[noOfYears];
        int i = startYear;
        int y = 0;
        while (i < startYear + noOfYears) {
            years[y] = startYear + y;
            ++i;
            ++y;
        }
        return years;
    }

    public String[] getMonthNames() {
        return this.dfs.getMonths();
    }

    public String[] getMonthShortNames() {
        DateFormatSymbols dfs = new DateFormatSymbols(this.locale);
        return dfs.getShortMonths();
    }

    public String[] getDayNames() {
        return this.dfs.getWeekdays();
    }

    public String[] getDayShortNames() {
        return this.dfs.getShortWeekdays();
    }

    public String[] getAmPm() {
        return ampm;
    }

    public Integer[] getMonths() {
        return months;
    }

    public Integer[] getDays() {
        return days;
    }

    public Integer[] getHours() {
        return this.getHours(true);
    }

    public Integer[] getHours(boolean twentyFourHour) {
        return twentyFourHour ? hours24 : hours12;
    }

    public Integer[] getMinutes() {
        return minutes;
    }

    public Integer[] getSeconds() {
        return seconds;
    }

    public static void main(String[] args) {
        int i;
        DateModel dateModel1 = new DateModel();
        Integer[] ye = dateModel1.getYears(2, 2);
        Integer[] mo = dateModel1.getMonths();
        Integer[] da = dateModel1.getDays();
        Integer[] h12 = dateModel1.getHours(false);
        Integer[] h24 = dateModel1.getHours();
        Integer[] mi = dateModel1.getMinutes();
        Integer[] se = dateModel1.getSeconds();
        String[] ap = dateModel1.getAmPm();
        for (i = 0; i < ye.length; ++i) {
            System.out.println("year: " + ye[i]);
        }
        for (i = 0; i < mo.length; ++i) {
            System.out.println("month: " + mo[i]);
        }
        for (i = 0; i < da.length; ++i) {
            System.out.println("day: " + da[i]);
        }
        for (i = 0; i < h12.length; ++i) {
            System.out.println("hour 12: " + h12[i]);
        }
        for (i = 0; i < h24.length; ++i) {
            System.out.println("hour 24: " + h24[i]);
        }
        for (i = 0; i < mi.length; ++i) {
            System.out.println("minutes: " + mi[i]);
        }
        for (i = 0; i < se.length; ++i) {
            System.out.println("seconds: " + se[i]);
        }
        for (i = 0; i < se.length; ++i) {
            String zs = dateModel1.zeroPad(se[i].toString());
            System.out.println("zero pad seconds=" + zs);
        }
        for (i = 0; i < ap.length; ++i) {
            System.out.println("am pm: " + ap[i]);
        }
        System.out.println("testing select items 12hr");
        DateModel.unitTestSelectItemList(dateModel1.get12HourSelectItems());
        System.out.println("testing select items 24hr");
        DateModel.unitTestSelectItemList(dateModel1.get24HourSelectItems());
        System.out.println("testing select items am pm");
        DateModel.unitTestSelectItemList(dateModel1.getAmPmSelectItems());
        System.out.println("testing select items day");
        DateModel.unitTestSelectItemList(dateModel1.getDaySelectItems());
        System.out.println("testing select items minute");
        DateModel.unitTestSelectItemList(dateModel1.getMinuteSelectItems());
        System.out.println("testing select items month");
        DateModel.unitTestSelectItemList(dateModel1.getMonthSelectItems());
        System.out.println("testing select items second");
        DateModel.unitTestSelectItemList(dateModel1.getSecondsSelectItems());
        System.out.println("testing select items year");
        DateModel.unitTestSelectItemList(dateModel1.getYearSelectItems(2, 2));
    }

    private static void unitTestSelectItemList(List list) {
        for (SelectItem item : list) {
            System.out.println("item.getLabel()=" + item.getLabel());
            System.out.println("item.getValue()=" + item.getValue());
        }
    }

    public List getYearSelectItems(int rangeBefore, int rangeAfter) {
        ArrayList<SelectItem> selectYears = new ArrayList<SelectItem>();
        Integer[] years = this.getYears(rangeBefore, rangeAfter);
        for (int i = 0; i < years.length; ++i) {
            SelectItem selectYear = new SelectItem((Object)years[i], years[i].toString());
            selectYears.add(selectYear);
        }
        return selectYears;
    }

    public List getMonthSelectItems() {
        ArrayList<SelectItem> selectMonths = new ArrayList<SelectItem>();
        Integer[] m = this.getMonths();
        for (int i = 0; i < m.length; ++i) {
            SelectItem selectMonth = new SelectItem((Object)m[i], m[i].toString());
            selectMonths.add(selectMonth);
        }
        return selectMonths;
    }

    public List getDaySelectItems() {
        ArrayList selectDays = new ArrayList();
        Integer[] d = this.getDays();
        for (int i = 0; i < d.length; ++i) {
            SelectItem selectItem = new SelectItem((Object)d[i], d[i].toString());
        }
        return selectDays;
    }

    public List get24HourSelectItems() {
        ArrayList<SelectItem> selectHours = new ArrayList<SelectItem>();
        Integer[] h = this.getHours();
        for (int i = 0; i < h.length; ++i) {
            String hourStr = this.zeroPad(h[i].toString());
            SelectItem selectHour = new SelectItem((Object)h[i], hourStr);
            selectHours.add(selectHour);
        }
        return selectHours;
    }

    public List get12HourSelectItems() {
        ArrayList<SelectItem> selectHours = new ArrayList<SelectItem>();
        Integer[] h = this.getHours(false);
        for (int i = 0; i < h.length; ++i) {
            String hourStr = this.zeroPad(h[i].toString());
            SelectItem selectHour = new SelectItem((Object)h[i], hourStr);
            selectHours.add(selectHour);
        }
        return selectHours;
    }

    public List getAmPmSelectItems() {
        ArrayList<SelectItem> ampmList = new ArrayList<SelectItem>();
        String[] ampm = this.getAmPm();
        for (int i = 0; i < ampm.length; ++i) {
            ampmList.add(new SelectItem((Object)i, ampm[i]));
        }
        return ampmList;
    }

    public List getMinuteSelectItems() {
        ArrayList<SelectItem> selectMinutes = new ArrayList<SelectItem>();
        Integer[] m = this.getMinutes();
        for (int i = 0; i < m.length; ++i) {
            String minStr = this.zeroPad(m[i].toString());
            SelectItem selectHour = new SelectItem((Object)m[i], minStr);
            selectMinutes.add(selectHour);
        }
        return selectMinutes;
    }

    public List getSecondsSelectItems() {
        ArrayList<SelectItem> selectSeconds = new ArrayList<SelectItem>();
        Integer[] s = this.getSeconds();
        for (int i = 0; i < s.length; ++i) {
            String secStr = this.zeroPad(s[i].toString());
            SelectItem selectHour = new SelectItem((Object)s[i], secStr);
            selectSeconds.add(selectHour);
        }
        return selectSeconds;
    }

    private static Integer[] makeArray(int entries, boolean zeroBase) {
        Integer[] mk = new Integer[entries];
        int incr = 1;
        if (zeroBase) {
            incr = 0;
        }
        for (int i = 0; i < entries; ++i) {
            mk[i] = i + incr;
        }
        return mk;
    }

    private String zeroPad(String str) {
        if (str == null) {
            return "00";
        }
        if (str.length() < 2) {
            str = "0" + str;
        }
        return str;
    }

    static {
        ampm = new String[]{"AM", "PM"};
        months = DateModel.makeArray(12, false);
        days = DateModel.makeArray(31, false);
        hours12 = DateModel.makeArray(12, false);
        hours24 = DateModel.makeArray(24, false);
        minutes = DateModel.makeArray(60, true);
        seconds = DateModel.makeArray(60, true);
    }
}

