/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.jsf.util.RendererUtil;
import org.sakaiproject.tool.api.SessionManager;

public class CourierRenderer
extends Renderer {
    private SessionManager sessionManager = (SessionManager)ComponentManager.get(SessionManager.class);

    public boolean supportsComponentType(UIComponent component) {
        return component instanceof UIOutput;
    }

    public void decode(FacesContext context, UIComponent component) {
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String userId;
        String placementId;
        ResponseWriter writer = context.getResponseWriter();
        HttpServletRequest req = (HttpServletRequest)context.getExternalContext().getRequest();
        String updateTime = (String)RendererUtil.getAttribute(context, component, "refresh");
        if (updateTime == null || updateTime.length() == 0) {
            updateTime = "10";
        }
        if ((placementId = (String)req.getAttribute("sakai.tool.placement.id")) == null) {
            try {
                throw new Exception("Placement ID is null in request: sakai.tool.placement.id");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((userId = this.sessionManager.getCurrentSessionUserId()) == null) {
            try {
                throw new Exception("User ID is null in session");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        writer.write("<script type=\"text/javascript\" language=\"JavaScript\">\n");
        writer.write("updateTime = " + updateTime + "000;\n");
        writer.write("updateUrl = \"" + CourierRenderer.serverUrl(req) + "/courier/" + placementId);
        writer.write("?userId=" + userId + "\";\n");
        writer.write("scheduleUpdate();\n");
        writer.write("</script>\n");
    }

    private static String serverUrl(HttpServletRequest req) {
        StringBuilder url = new StringBuilder();
        url.append(req.getScheme());
        url.append("://");
        url.append(req.getServerName());
        if (req.getServerPort() != 80 && !req.isSecure() || req.getServerPort() != 443 && req.isSecure()) {
            url.append(":");
            url.append(req.getServerPort());
        }
        return url.toString();
    }
}

