/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.sakaiproject.jsf.util.ConfigurationResource;
import org.sakaiproject.jsf.util.LocaleUtil;
import org.sakaiproject.jsf.util.RendererUtil;

public class InputDateRenderer
extends Renderer {
    private static final String HEIGHT = "16";
    private static final String WIDTH = "16";
    private static final boolean inputTimeSeconds = true;

    public boolean supportsComponentType(UIComponent component) {
        return component instanceof UIInput;
    }

    public void decode(FacesContext context, UIComponent component) {
        if (RendererUtil.isDisabledOrReadonly(context, component)) {
            return;
        }
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(context);
        String dateStr = (String)requestParameterMap.get(clientId + "_date");
        String timeStr = (String)requestParameterMap.get(clientId + "_time");
        if (dateStr == null && timeStr == null) {
            return;
        }
        EditableValueHolder ev = (EditableValueHolder)component;
        ConfigurationResourceBean crb = new ConfigurationResourceBean(LocaleUtil.getLocale(context));
        Date date = null;
        if (dateStr == null && timeStr != null) {
            try {
                date = crb.getTimeFormat().parse(timeStr);
            }
            catch (ParseException parseException) {}
        } else if (dateStr != null && timeStr == null) {
            try {
                date = crb.getDateFormat().parse(dateStr);
            }
            catch (ParseException parseException) {}
        } else {
            try {
                date = crb.getDateTimeFormat().parse(dateStr + " " + timeStr);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        ev.setSubmittedValue((Object)date);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (RendererUtil.isDisabledOrReadonly(context, component) || !component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        ConfigurationResourceBean crb = new ConfigurationResourceBean(LocaleUtil.getLocale(context));
        String dateString = "";
        String timeString = "";
        Date date = null;
        Date submittedValue = (Date)((EditableValueHolder)component).getSubmittedValue();
        if (submittedValue != null) {
            date = submittedValue;
        } else {
            Object value = ((ValueHolder)component).getValue();
            if (value instanceof Date) {
                date = (Date)value;
            } else if (value instanceof String) {
                try {
                    date = crb.getDateTimeFormat().parse((String)value);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if (date != null) {
            dateString = crb.getDateFormat().format(date);
            timeString = crb.getTimeFormat().format(date);
        }
        boolean showDate = "true".equals((String)RendererUtil.getAttribute(context, component, "showDate"));
        boolean showTime = "true".equals((String)RendererUtil.getAttribute(context, component, "showTime"));
        boolean showSecond = "true".equals((String)RendererUtil.getAttribute(context, component, "showSecond"));
        if (showDate) {
            writer.write("<i>&#160;" + crb.getDateHint() + "&#160;</i>");
            String dateId = clientId + "_date";
            String type = "text";
            writer.write("<input type=\"" + type + "\" size=\"" + crb.getDateFormatString().length() + "\" name=\"" + dateId + "\" id=\"" + dateId + "\" value=\"" + dateString + "\">&#160;");
            String calRand = "cal" + ("" + Math.random()).substring(2);
            String calendar = crb.isInputMonthFirst() ? "calendar2" : "calendar1";
            String calScript = "var " + calRand + " = new " + calendar + "(document.getElementById('" + dateId + "'));" + calRand + ".year_scroll = true;" + calRand + ".time_comp = false;";
            writer.write("&#160;<img");
            writer.write("  id=\"" + clientId + "_datePickerPopup\"");
            writer.write("  width=\"16\"\n");
            writer.write("  height=\"16\"\n");
            writer.write("  style=\"" + crb.getCursorStyle() + "\" ");
            writer.write("  src=\"" + crb.getCalendarIcon() + "\"\n");
            writer.write("  border=\"0\"\n");
            writer.write("  onclick=");
            writer.write("\"javascript:" + calScript + calRand + ".popup('','" + crb.getCalendarPath() + "');\"\n");
            writer.write("  alt=\"" + crb.getClickAlt() + "\"\n");
            writer.write(" />&#160;&#160;\n");
        }
        if (showTime) {
            writer.write("<i>&#160;" + crb.getTimeHint() + "&#160;</i>");
            String timeId = clientId + "_time";
            writer.write("<input type=\"text\" size=\"" + (crb.getDateFormatString().length() + 1) + "\" name=\"" + timeId + "\" id=\"" + timeId + "\" value=\"" + timeString + "\">&#160;");
        }
    }

    private class ConfigurationResourceBean {
        private final String cursorStyle;
        private final String clickAlt;
        private final String calendarPath;
        private final String calendarIcon;
        private final boolean inputMonthFirst;
        private final String dateFormatString;
        private final SimpleDateFormat dateFormat;
        private final SimpleDateFormat timeFormat;
        private final SimpleDateFormat dateTimeFormat;
        private final String dateHint;
        private final String timeHint;

        public ConfigurationResourceBean(Locale locale) {
            ConfigurationResource cr = new ConfigurationResource(locale);
            String resources = cr.get("resources");
            this.cursorStyle = cr.get("picker_style");
            this.calendarPath = "/" + resources + "/" + cr.get("inputDatePopup");
            this.calendarIcon = "/" + resources + "/" + cr.get("inputDateImage");
            this.clickAlt = cr.get("date_pick_alt");
            this.inputMonthFirst = Boolean.valueOf(cr.get("inputMonthFirst"));
            boolean inputTimeColon = Boolean.valueOf(cr.get("inputTimeColon"));
            boolean inputTime24 = Boolean.valueOf(cr.get("inputTime24"));
            this.dateHint = cr.get("inputDateHint");
            this.timeHint = cr.get("inputTimeHint");
            this.dateFormatString = this.inputMonthFirst ? cr.get("inputMonthFirstFormat") : cr.get("inputDayFirstFormat");
            String timeFormatString = inputTimeColon ? (inputTime24 ? cr.get("inputTimeColonFormat24") : cr.get("inputTimeColonFormatAMPM")) : (inputTime24 ? cr.get("inputTimeDotFormat24") : cr.get("inputTimeDotFormatAMPM"));
            this.dateFormat = new SimpleDateFormat(this.dateFormatString, locale);
            this.timeFormat = new SimpleDateFormat(timeFormatString, locale);
            this.dateTimeFormat = new SimpleDateFormat(this.dateFormatString + " " + timeFormatString, locale);
        }

        public String getCursorStyle() {
            return this.cursorStyle;
        }

        public String getClickAlt() {
            return this.clickAlt;
        }

        public String getCalendarPath() {
            return this.calendarPath;
        }

        public String getCalendarIcon() {
            return this.calendarIcon;
        }

        public boolean isInputMonthFirst() {
            return this.inputMonthFirst;
        }

        public String getDateFormatString() {
            return this.dateFormatString;
        }

        public SimpleDateFormat getDateFormat() {
            return this.dateFormat;
        }

        public SimpleDateFormat getTimeFormat() {
            return this.timeFormat;
        }

        public SimpleDateFormat getDateTimeFormat() {
            return this.dateTimeFormat;
        }

        public String getDateHint() {
            return this.dateHint;
        }

        public String getTimeHint() {
            return this.timeHint;
        }
    }
}

