/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.sakaiproject.jsf.util.RendererUtil;

public class InputFileUploadRenderer
extends Renderer {
    private static final String ID_INPUT_ELEMENT = ".uploadId";
    private static final String ID_HIDDEN_ELEMENT = ".hiddenId";
    private static final String ATTR_REQUEST_DECODED = ".decoded";
    private static final String[] PASSTHROUGH_ATTRIBUTES = new String[]{"accept", "accesskey", "align", "disabled", "maxlength", "readonly", "size", "style", "tabindex"};
    public static final String ATTR_UPLOADS_DONE = "sakai.uploads.done";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        boolean atDecodeTime;
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        String errorMessage = InputFileUploadRenderer.checkForErrors(context, component, clientId, atDecodeTime = false);
        if (errorMessage != null) {
            InputFileUploadRenderer.addFacesMessage(context, clientId, errorMessage);
        }
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"file", null);
        writer.writeAttribute("name", (Object)(clientId + ID_INPUT_ELEMENT), null);
        String styleClass = (String)RendererUtil.getAttribute(context, component, "styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        boolean writeNullPassthroughAttributes = false;
        RendererUtil.writePassthroughAttributes(PASSTHROUGH_ATTRIBUTES, writeNullPassthroughAttributes, context, component);
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)(clientId + ID_HIDDEN_ELEMENT), null);
        writer.writeAttribute("value", (Object)"filter_is_functioning_properly", null);
        writer.endElement("input");
    }

    public void decode(FacesContext context, UIComponent comp) {
        UIInput component = (UIInput)comp;
        if (!component.isRendered()) {
            return;
        }
        ExternalContext external = context.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)external.getRequest();
        String clientId = component.getClientId(context);
        String directory = (String)RendererUtil.getAttribute(context, (UIComponent)component, "directory");
        request.setAttribute(clientId + ATTR_REQUEST_DECODED, (Object)"true");
        boolean atDecodeTime = true;
        String errorMessage = InputFileUploadRenderer.checkForErrors(context, (UIComponent)component, clientId, atDecodeTime);
        if (errorMessage != null) {
            InputFileUploadRenderer.addFacesMessage(context, clientId, errorMessage);
            return;
        }
        FileItem item = InputFileUploadRenderer.getFileItem(context, (UIComponent)component);
        if (item.getName() == null || item.getName().length() == 0) {
            if (component.isRequired()) {
                InputFileUploadRenderer.addFacesMessage(context, clientId, "Please specify a file.");
                component.setValid(false);
            }
            return;
        }
        if (directory == null || directory.length() == 0) {
            component.setSubmittedValue((Object)item);
        } else {
            File dir = new File(directory);
            String filename = item.getName();
            filename = filename.replace('\\', '/');
            filename = filename.substring(filename.lastIndexOf("/") + 1);
            File persistentFile = new File(dir, filename);
            try {
                item.write(persistentFile);
                component.setSubmittedValue((Object)persistentFile.getPath());
            }
            catch (Exception ex) {
                throw new FacesException((Throwable)ex);
            }
        }
    }

    private static String checkForErrors(FacesContext context, UIComponent component, String clientId, boolean atDecodeTime) {
        File dir;
        ExternalContext external = context.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)external.getRequest();
        UIForm form = null;
        try {
            form = InputFileUploadRenderer.getForm(component);
        }
        catch (IllegalArgumentException e) {
            return "DEVELOPER ERROR: The <inputFileUpload> tag must be enclosed in just ONE form.  Nested forms confuse the browser.";
        }
        if (form == null || !"multipart/form-data".equals(RendererUtil.getAttribute(context, (UIComponent)form, "enctype"))) {
            return "DEVELOPER ERROR: The <inputFileUpload> tag must be enclosed in a <h:form enctype=\"multipart/form-data\"> tag.";
        }
        String directory = (String)RendererUtil.getAttribute(context, component, "directory");
        if (!(directory == null || directory.length() == 0 || (dir = new File(directory)).isDirectory() && dir.exists())) {
            return "DEVELOPER ERROR: The directory specified on the <inputFileUpload> tag does not exist or is not writable.\nCheck the permissions on directory:\n" + dir;
        }
        FileItem item = InputFileUploadRenderer.getFileItem(context, component);
        boolean isMultipartRequest = request.getContentType() != null && request.getContentType().startsWith("multipart/form-data");
        boolean wasMultipartRequestFullyParsed = request.getParameter(clientId + ID_HIDDEN_ELEMENT) != null;
        String requestFilterStatus = (String)request.getAttribute("upload.status");
        Object requestFilterUploadLimit = request.getAttribute("upload.limit");
        Exception requestFilterException = (Exception)request.getAttribute("upload.exception");
        boolean wasDecodeAlreadyCalledOnTheRequest = "true".equals(request.getAttribute(clientId + ATTR_REQUEST_DECODED));
        if (wasDecodeAlreadyCalledOnTheRequest && !atDecodeTime) {
            return null;
        }
        if (!isMultipartRequest) {
            return null;
        }
        if ("exception".equals(requestFilterStatus)) {
            return "An error occured while processing the uploaded file.  The error was:\n" + requestFilterException;
        }
        if ("size_limit_exceeded".equals(requestFilterStatus)) {
            return "The upload size limit of " + requestFilterUploadLimit + "MB has been exceeded.";
        }
        if (item == null || item.getName() == null || item.getName().length() == 0) {
            return null;
        }
        if (item.getSize() == 0L) {
            return "The filename '" + item.getName() + "' is invalid.  Please select a valid file.";
        }
        if (!wasMultipartRequestFullyParsed) {
            return "An error occured while processing the uploaded file.  The error was:\nDEVELOPER ERROR: The <inputFileUpload> tag requires a <filter> in web.xml to parse the uploaded file.\nCheck that the Sakai RequestFilter is properly configured in web.xml.";
        }
        if (item.getName().indexOf("..") >= 0) {
            return "The filename '" + item.getName() + "' is invalid.  Please select a valid file.";
        }
        return null;
    }

    private static FileItem getFileItem(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        FileItem item = null;
        String fieldName = clientId + ID_INPUT_ELEMENT;
        item = (FileItem)request.getAttribute(fieldName);
        if (item != null) {
            return item;
        }
        while (request != null) {
            try {
                Class<?> reqClass = request.getClass();
                Method getFileItemMethod = reqClass.getMethod("getFileItem", String.class);
                Object returned = getFileItemMethod.invoke((Object)request, fieldName);
                if (returned instanceof FileItem) {
                    return (FileItem)returned;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (request instanceof HttpServletRequestWrapper) {
                request = (HttpServletRequest)((HttpServletRequestWrapper)request).getRequest();
                continue;
            }
            request = null;
        }
        return null;
    }

    private static void addFacesMessage(FacesContext context, String clientId, String message) {
        context.addMessage(clientId, new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message));
    }

    private static UIForm getForm(UIComponent component) throws IllegalArgumentException {
        UIForm ret = null;
        while (component != null) {
            if (component instanceof UIForm) {
                if (ret != null) {
                    throw new IllegalArgumentException();
                }
                ret = (UIForm)component;
            }
            component = component.getParent();
        }
        return ret;
    }
}

