/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.IOException;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.render.Renderer;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.jsf.component.InputRichTextComponent;
import org.sakaiproject.jsf.model.InitObjectContainer;
import org.sakaiproject.jsf.util.ConfigurationResource;
import org.sakaiproject.jsf.util.RendererUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputRichTextRenderer
extends Renderer {
    private static final String SCRIPT_PATH;
    private static final String HTMLAREA_SCRIPT_PATH;
    private static final String RESOURCE_PATH;
    private static final String TOOLBAR_SCRIPT_NONE;
    private static final String TOOLBAR_SCRIPT_SMALL;
    private static final String TOOLBAR_SCRIPT_MEDIUM;
    private static final String TOOLBAR_SCRIPT_LARGE;
    private static final int DEFAULT_WIDTH_PX;
    private static final int DEFAULT_HEIGHT_PX;
    private static final int DEFAULT_COLUMNS;
    private static final int DEFAULT_ROWS;
    private static final String INSERT_IMAGE_LOC;
    private static final MessageFormat LIST_ITEM_FORMAT_HTML;
    private static final MessageFormat LIST_ITEM_FORMAT_FCK;
    private static final Logger log;

    public boolean supportsComponentType(UIComponent component) {
        return component instanceof InputRichTextComponent;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        String contextPath = context.getExternalContext().getRequestContextPath() + SCRIPT_PATH;
        String clientId = component.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        String value = null;
        if (component instanceof UIInput) {
            value = (String)((UIInput)component).getSubmittedValue();
        }
        if (value == null && component instanceof ValueHolder) {
            value = (String)((ValueHolder)component).getValue();
        }
        if (value != null) {
            Pattern pattern = Pattern.compile("&([^\\s])");
            value = pattern.matcher(value).replaceAll("&amp;$1");
        }
        String textareaOnly = (String)RendererUtil.getAttribute(context, component, "textareaOnly");
        String buttonSet = (String)RendererUtil.getAttribute(context, component, "buttonSet");
        String buttonList = (String)RendererUtil.getAttribute(context, component, "buttonList");
        String enableFullPage = (String)RendererUtil.getAttribute(context, component, "enableFullPage");
        String javascriptLibraryExtensionURL = (String)RendererUtil.getAttribute(context, component, "javascriptLibraryExtensionURL");
        String javascriptLibraryURL = (String)RendererUtil.getAttribute(context, component, "javascriptLibraryURL");
        String showXPath = (String)RendererUtil.getAttribute(context, component, "showXPath");
        showXPath = RendererUtil.makeSwitchString(showXPath, true, true, true, false, false, true);
        int widthPx = DEFAULT_WIDTH_PX;
        int heightPx = DEFAULT_HEIGHT_PX;
        int textareaColumns = DEFAULT_COLUMNS;
        int textareaRows = DEFAULT_ROWS;
        try {
            Integer height;
            Integer width;
            Integer cols = Integer.parseInt("" + RendererUtil.getAttribute(context, component, "cols"));
            Integer rows = Integer.parseInt("" + RendererUtil.getAttribute(context, component, "rows"));
            if (cols != null) {
                textareaColumns = cols;
            }
            if (rows != null) {
                textareaRows = rows;
            }
            if ((width = (Integer)RendererUtil.getAttribute(context, component, "width")) != null) {
                widthPx = width;
            }
            if ((height = (Integer)RendererUtil.getAttribute(context, component, "height")) != null) {
                heightPx = height;
            }
        }
        catch (Exception ex) {
            log.debug(ex.getMessage());
        }
        if (widthPx == DEFAULT_WIDTH_PX && textareaColumns != DEFAULT_COLUMNS) {
            widthPx = DEFAULT_WIDTH_PX * textareaColumns / DEFAULT_COLUMNS;
        }
        if (heightPx == DEFAULT_HEIGHT_PX && textareaRows != DEFAULT_ROWS) {
            heightPx = DEFAULT_HEIGHT_PX * textareaRows / DEFAULT_ROWS;
        }
        Locale locale = Locale.getDefault();
        ServerConfigurationService serverConfigurationService = (ServerConfigurationService)ComponentManager.get((String)ServerConfigurationService.class.getName());
        String editor = serverConfigurationService.getString("wysiwyg.editor");
        String collectionBase = (String)RendererUtil.getAttribute(context, component, "collectionBase");
        String collectionId = "";
        if (collectionBase != null) {
            collectionId = "collectionId: '" + collectionBase.replaceAll("\"", "\\\"") + "'";
        }
        writer.write("<table border=\"0\"><tr><td>");
        writer.write("<textarea name=\"" + clientId + "_inputRichText\" id=\"" + clientId + "_inputRichText\"");
        if (textareaColumns > 0) {
            writer.write(" cols=\"" + textareaColumns + "\"");
        }
        if (textareaRows > 0) {
            writer.write(" rows=\"" + textareaRows + "\"");
        }
        writer.write(">");
        if (value != null) {
            writer.write(value);
        }
        writer.write("</textarea>");
        if (!"true".equals(textareaOnly)) {
            if (enableFullPage != null && "true".equals(enableFullPage)) {
                writer.write("<script type=\"text/javascript\" defer=\"1\">");
                writer.write("function config(){}");
                writer.write("config.prototype.fullPage=true;");
                writer.write("config.prototype.width=" + widthPx + ";");
                writer.write("config.prototype.height=" + heightPx + ";");
                if (collectionBase != null) {
                    writer.write("config.prototype.collectionId='" + collectionBase.replaceAll("\"", "\\\"") + "';");
                }
                writer.write("sakai.editor.launch('" + clientId + "_inputRichText', new config(), " + widthPx + ", " + heightPx + ");</script>");
            } else {
                writer.write("<script type=\"text/javascript\">sakai.editor.launch('" + clientId + "_inputRichText', {" + collectionId + "}, '" + widthPx + "','" + heightPx + "');</script>");
            }
        }
        writer.write("</td></tr></table>\n");
    }

    private String getStandardToolbarScript(String buttonSet) {
        String toolbarScript = "none".equals(buttonSet) ? TOOLBAR_SCRIPT_NONE : ("small".equals(buttonSet) ? TOOLBAR_SCRIPT_SMALL : ("medium".equals(buttonSet) ? TOOLBAR_SCRIPT_MEDIUM : ("large".equals(buttonSet) ? TOOLBAR_SCRIPT_LARGE : TOOLBAR_SCRIPT_MEDIUM)));
        return toolbarScript;
    }

    private void writeTextArea(String clientId, String value, int rows, int cols, ResponseWriter writer) throws IOException {
        writer.write("<table border=\"0\"><tr><td>\n");
        writer.write("<textarea name=\"");
        writer.write(clientId);
        writer.write("_inputRichText\" id=\"");
        writer.write(clientId);
        writer.write("_inputRichText\"");
        writer.write(" rows=\"" + rows + "\"");
        writer.write(" cols=\"" + cols + "\"");
        writer.write(">" + value + "</textarea>\n");
        writer.write("</td></tr></table>\n");
    }

    protected void writeExternalScripts(Locale locale, ResponseWriter writer) throws IOException {
        writer.write("<script type=\"text/javascript\">var _editor_url = \"/" + RESOURCE_PATH + "/" + HTMLAREA_SCRIPT_PATH + "/\";</script>\n");
        writer.write("<script type=\"text/javascript\" src=\"/" + RESOURCE_PATH + "/" + HTMLAREA_SCRIPT_PATH + "/htmlarea.js\"></script>\n");
        writer.write("<script type=\"text/javascript\" src=\"/" + RESOURCE_PATH + "/" + HTMLAREA_SCRIPT_PATH + "/dialog.js\"></script>\n");
        writer.write("<script type=\"text/javascript\" src=\"/" + RESOURCE_PATH + "/" + HTMLAREA_SCRIPT_PATH + "/popupwin.js\"></script>\n");
        writer.write("<script type=\"text/javascript\" src=\"/" + RESOURCE_PATH + "/" + HTMLAREA_SCRIPT_PATH + "/lang/en.js\"></script>\n");
        String language = locale.getLanguage();
        if (!Locale.ENGLISH.getLanguage().equals(language)) {
            writer.write("<script type=\"text/javascript\" src=\"/" + RESOURCE_PATH + "/" + HTMLAREA_SCRIPT_PATH + "/lang/" + language + ".js\"></script>\n");
        }
        writer.write("<script type=\"text/javascript\" src=\"/" + RESOURCE_PATH + "/" + SCRIPT_PATH + "\"></script>\n");
    }

    public void decode(FacesContext context, UIComponent component) {
        if (RendererUtil.isDisabledOrReadonly(context, component)) {
            return;
        }
        if (null == context || null == component || !(component instanceof InputRichTextComponent)) {
            throw new IllegalArgumentException();
        }
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestParameterMap.get(clientId + "_inputRichText");
        InputRichTextComponent comp = (InputRichTextComponent)component;
        comp.setSubmittedValue(newValue);
    }

    protected void writeConfigurationScript(FacesContext context, UIComponent component, String clientId, String toolbar, int widthPx, int heightPx, String showXPath, Locale locale, ResponseWriter writer) throws IOException {
        String configVar = "config" + this.createSafeRandomNumber();
        writer.write("<script type=\"text/javascript\">\n");
        writer.write("  sakaiSetLanguage(\"" + locale.getDisplayLanguage() + "\");");
        writer.write("  var " + configVar + "=new HTMLArea.Config();\n");
        writer.write("  sakaiRegisterButtons(" + configVar + ");\n");
        writer.write("  " + configVar + ".toolbar = " + toolbar + ";\n");
        writer.write("  " + configVar + ".width=\"" + widthPx + "px\";\n");
        writer.write("  " + configVar + ".height=\"" + heightPx + "px\";\n");
        writer.write("  " + configVar + ".statusBar=" + showXPath + ";\n");
        this.writeAdditionalConfig(context, component, configVar, clientId, toolbar, widthPx, heightPx, locale, writer);
        writer.write("sakaiSetupRichTextarea(\"");
        writer.write(clientId);
        writer.write("_inputRichText\"," + configVar + ");\n");
        writer.write("</script>\n");
    }

    protected void writeAdditionalConfig(FacesContext context, UIComponent component, String configVar, String clientId, String toolbar, int widthPx, int heightPx, Locale locale, ResponseWriter writer) throws IOException {
        this.writeAttachedFiles(context, component, configVar, writer, toolbar);
        this.registerWithParent(component, configVar, clientId);
    }

    protected void writeAttachedFiles(FacesContext context, UIComponent component, String configVar, ResponseWriter writer, String toolbar) throws IOException {
        Object attchedFiles = RendererUtil.getAttribute(context, component, "attachedFiles");
        if (attchedFiles != null && this.getSize(attchedFiles) > 0) {
            String arrayVar = configVar + "_Resources";
            this.writeFilesArray(writer, arrayVar, attchedFiles, LIST_ITEM_FORMAT_HTML, true);
            writer.write("sakaiRegisterResourceList(");
            writer.write(configVar + ",'" + INSERT_IMAGE_LOC + "'," + arrayVar);
            writer.write(");\n");
            writer.write("  " + configVar + ".toolbar = " + this.addToolbar(toolbar) + ";\n");
        }
    }

    protected void writeFilesArray(ResponseWriter writer, String arrayVar, Object attchedFiles, MessageFormat format, boolean includeLabel) throws IOException {
        StringWriter buffer = new StringWriter();
        char startChar = '[';
        char endChar = ']';
        if (format == LIST_ITEM_FORMAT_HTML) {
            startChar = '{';
            endChar = '}';
        }
        buffer.write("  var " + arrayVar + " = " + startChar + "\n");
        if (includeLabel) {
            buffer.write("\"select a file url to insert\" : \"\"");
        }
        if (attchedFiles instanceof Map) {
            buffer.write(this.outputFiles((Map)attchedFiles, format, !includeLabel));
        } else {
            buffer.write(this.outputFiles((List)attchedFiles, format, !includeLabel));
        }
        buffer.write(endChar + ";\n");
        String result = buffer.toString();
        writer.write(result);
    }

    protected void registerWithParent(UIComponent component, String configVar, String clientId) {
        InitObjectContainer parentContainer = null;
        for (UIComponent testContainer = component.getParent(); testContainer != null; testContainer = testContainer.getParent()) {
            if (!(testContainer instanceof InitObjectContainer)) continue;
            parentContainer = (InitObjectContainer)testContainer;
            String script = " resetRichTextEditor(\"" + clientId + "_inputRichText\"," + configVar + ");\n";
            parentContainer.addInitScript(script);
        }
    }

    protected String outputFiles(Map map, MessageFormat format, boolean first) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : map.entrySet()) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            format.format(new Object[]{entry.getValue(), entry.getKey()}, sb, (FieldPosition)null);
        }
        return sb.toString();
    }

    protected String outputFiles(List list, MessageFormat format, boolean first) {
        StringBuffer sb = new StringBuffer();
        for (Object value : list) {
            String label;
            String url;
            if (value instanceof SelectItem) {
                SelectItem item = (SelectItem)value;
                url = item.getValue().toString();
                label = item.getLabel();
            } else {
                url = value.toString();
                label = value.toString();
            }
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            format.format(new Object[]{label, url}, sb, (FieldPosition)null);
        }
        return sb.toString();
    }

    protected int getSize(Object attchedFiles) {
        if (attchedFiles instanceof Map) {
            return ((Map)attchedFiles).size();
        }
        return ((List)attchedFiles).size();
    }

    protected String addToolbar(String toolbar) {
        int pos = toolbar.lastIndexOf("]");
        toolbar = toolbar.substring(0, pos) + ",[\"filedropdown\", \"insertfile\", ]" + toolbar.substring(pos);
        return toolbar;
    }

    private static String makeToolbarScript(String buttonList) {
        StringBuilder script = new StringBuilder();
        String q = "\"";
        script.append("[[");
        StringTokenizer st = new StringTokenizer(buttonList, ",", false);
        while (st.hasMoreTokens()) {
            String command = st.nextToken();
            if (!"linebreak".equals(command)) {
                script.append(q + command + q + ", ");
                continue;
            }
            script.append("],[");
        }
        script.append("]]");
        return script.toString();
    }

    private String createSafeRandomNumber() {
        return "" + (long)Math.floor(Math.random() * 1.0E9);
    }

    static {
        LIST_ITEM_FORMAT_HTML = new MessageFormat("\"{0}\" : \"<a href=''{1}''>{0}</a>\"");
        LIST_ITEM_FORMAT_FCK = new MessageFormat("[\"{0}\", \"{1}\"]");
        log = LoggerFactory.getLogger(InputRichTextRenderer.class);
        ConfigurationResource cr = new ConfigurationResource();
        SCRIPT_PATH = cr.get("inputRichTextScript");
        HTMLAREA_SCRIPT_PATH = cr.get("inputRichTextHTMLArea");
        RESOURCE_PATH = cr.get("resources");
        TOOLBAR_SCRIPT_NONE = InputRichTextRenderer.makeToolbarScript(cr.get("inputRichText_none"));
        TOOLBAR_SCRIPT_SMALL = InputRichTextRenderer.makeToolbarScript(cr.get("inputRichText_small"));
        TOOLBAR_SCRIPT_MEDIUM = InputRichTextRenderer.makeToolbarScript(cr.get("inputRichText_medium"));
        TOOLBAR_SCRIPT_LARGE = InputRichTextRenderer.makeToolbarScript(cr.get("inputRichText_large"));
        DEFAULT_WIDTH_PX = Integer.parseInt(cr.get("inputRichTextDefaultWidthPx").trim());
        DEFAULT_HEIGHT_PX = Integer.parseInt(cr.get("inputRichTextDefaultHeightPx").trim());
        DEFAULT_COLUMNS = Integer.parseInt(cr.get("inputRichTextDefaultTextareaColumns").trim());
        DEFAULT_ROWS = Integer.parseInt(cr.get("inputRichTextDefaultTextareaRows").trim());
        INSERT_IMAGE_LOC = "/" + RESOURCE_PATH + "/" + cr.get("inputRichTextFileInsertImage");
    }
}

