/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.MissingResourceException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.sakaiproject.jsf.util.LocaleUtil;
import org.sakaiproject.jsf.util.RendererUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagerRenderer
extends Renderer {
    private static final Logger log = LoggerFactory.getLogger(PagerRenderer.class);
    private static final String BUNDLE_NAME = "org.sakaiproject.jsf.bundle.pager";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        boolean disabledNext;
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String clientId = component.getClientId(context);
        int pageSize = PagerRenderer.getInt(context, component, "pageSize", 0);
        int totalItems = PagerRenderer.getInt(context, component, "totalItems", 0);
        int firstItem = PagerRenderer.getInt(context, component, "firstItem", 0);
        int lastItem = PagerRenderer.getInt(context, component, "lastItem", -1);
        if (log.isDebugEnabled()) {
            log.debug("encodeBegin: firstItem=" + firstItem + ", pageSize=" + pageSize + ", value=" + PagerRenderer.getString(context, component, "value", null));
        }
        PagerRenderer.adjustState(context, component, firstItem, lastItem, pageSize, totalItems, firstItem, lastItem, pageSize);
        pageSize = PagerRenderer.getInt(context, component, "pageSize", 0);
        totalItems = PagerRenderer.getInt(context, component, "totalItems", 0);
        firstItem = PagerRenderer.getInt(context, component, "firstItem", 0);
        lastItem = PagerRenderer.getInt(context, component, "lastItem", -1);
        String idFirst = clientId + "_first";
        String idPrev = clientId + "_prev";
        String idNext = clientId + "_next";
        String idLast = clientId + "_last";
        String idPastItem = clientId + "_pastItem";
        boolean renderFirst = PagerRenderer.getBoolean(context, component, "renderFirst", true);
        boolean renderPrev = PagerRenderer.getBoolean(context, component, "renderPrev", true);
        boolean renderNext = PagerRenderer.getBoolean(context, component, "renderNext", true);
        boolean renderLast = PagerRenderer.getBoolean(context, component, "renderLast", true);
        boolean renderPageSize = PagerRenderer.getBoolean(context, component, "renderPageSize", true);
        String labelFirst = PagerRenderer.getString(context, component, "textFirst", "|<");
        String labelPrev = PagerRenderer.getString(context, component, "textPrev", "<");
        String labelNext = PagerRenderer.getString(context, component, "textNext", ">");
        String labelLast = PagerRenderer.getString(context, component, "textLast", ">|");
        String textItem = PagerRenderer.getString(context, component, "textItem", "items");
        String titleFirst = MessageFormat.format(PagerRenderer.getString(context, component, "titleFirst", "First {0} {1}"), pageSize, textItem);
        String titlePrev = MessageFormat.format(PagerRenderer.getString(context, component, "titlePrev", "Previous {0} {1}"), pageSize, textItem);
        String titleNext = MessageFormat.format(PagerRenderer.getString(context, component, "titleNext", "Next {0} {1}"), pageSize, textItem);
        String titleLast = MessageFormat.format(PagerRenderer.getString(context, component, "titleLast", "Last {0} {1}"), pageSize, textItem);
        boolean disabledFirst = firstItem == 0;
        boolean disabledPrev = firstItem == 0;
        boolean disabledLast = disabledNext = pageSize == 0 || firstItem + pageSize >= totalItems;
        boolean accesskeys = PagerRenderer.getBoolean(context, component, "accesskeys", false);
        String accesskeyFirst = accesskeys ? "f" : null;
        String accesskeyPrev = accesskeys ? "p" : null;
        String accesskeyNext = accesskeys ? "n" : null;
        String accesskeyLast = accesskeys ? "l" : null;
        String textPageSize = PagerRenderer.getString(context, component, "textPageSize", "Show {0}");
        String textPageSizeAll = PagerRenderer.getString(context, component, "textPageSizeAll", "all");
        String pageSizesStr = PagerRenderer.getString(context, component, "pageSizes", "5,10,20,50,100");
        String[] pageSizes = pageSizesStr.split(",");
        String idSelect = clientId + "_pageSize";
        String textStatus = totalItems > 0 ? PagerRenderer.getString(context, component, "textStatus", "Viewing {0} to {1} of {2} {3}") : PagerRenderer.getString(context, component, "textStatusZeroItems", "Viewing 0 {3}");
        Object[] args = new Object[]{String.valueOf(firstItem + 1), String.valueOf(lastItem), String.valueOf(totalItems), textItem};
        textStatus = MessageFormat.format(textStatus, args);
        String onchangeHandler = "javascript:this.form.submit(); return false;";
        String selectedValue = String.valueOf(pageSize);
        String[] optionTexts = new String[pageSizes.length + 1];
        String[] optionValues = new String[pageSizes.length + 1];
        for (int i = 0; i < pageSizes.length; ++i) {
            optionTexts[i] = MessageFormat.format(textPageSize, pageSizes[i]);
            optionValues[i] = pageSizes[i];
        }
        optionTexts[pageSizes.length] = MessageFormat.format(textPageSize, textPageSizeAll);
        optionValues[pageSizes.length] = "0";
        out.startElement("div", null);
        out.writeAttribute("class", (Object)"listNav", null);
        out.startElement("div", null);
        out.writeAttribute("class", (Object)"inlineForm", null);
        PagerRenderer.writeStatus(out, textStatus);
        PagerRenderer.writeButton(out, renderFirst, idFirst, labelFirst, disabledFirst, titleFirst, accesskeyFirst);
        PagerRenderer.writeButton(out, renderPrev, idPrev, labelPrev, disabledPrev, titlePrev, accesskeyPrev);
        PagerRenderer.writeSelect(out, renderPageSize, idSelect, optionTexts, optionValues, selectedValue, onchangeHandler);
        PagerRenderer.writeButton(out, renderNext, idNext, labelNext, disabledNext, titleNext, accesskeyNext);
        PagerRenderer.writeButton(out, renderLast, idLast, labelLast, disabledLast, titleLast, accesskeyLast);
        out.startElement("input", null);
        out.writeAttribute("type", (Object)"hidden", null);
        out.writeAttribute("name", (Object)idPastItem, null);
        out.writeAttribute("value", (Object)String.valueOf(firstItem), null);
        out.endElement("input");
        out.endElement("div");
        out.endElement("div");
    }

    private static void writeStatus(ResponseWriter out, String status) throws IOException {
        out.startElement("div", null);
        out.writeAttribute("class", (Object)"pager-instruction", null);
        out.writeText((Object)status, null);
        out.endElement("div");
    }

    private static void writeButton(ResponseWriter out, boolean render, String name, String label, boolean disabled, String title, String accesskey) throws IOException {
        if (!render) {
            return;
        }
        out.startElement("fieldset", null);
        out.startElement("legend", null);
        out.writeText((Object)title, null);
        out.endElement("legend");
        out.startElement("input", null);
        out.writeAttribute("type", (Object)"submit", null);
        out.writeAttribute("name", (Object)name, null);
        out.writeAttribute("value", (Object)label, null);
        if (!disabled) {
            out.writeAttribute("title", (Object)title, null);
            if (accesskey != null) {
                out.writeAttribute("accesskey", (Object)accesskey, null);
            }
        } else {
            out.writeAttribute("disabled", (Object)"disabled", null);
        }
        out.endElement("input");
        out.endElement("fieldset");
        out.write("\n");
    }

    private static void writeSelect(ResponseWriter out, boolean render, String selectId, String[] optionTexts, String[] optionValues, String selectedValue, String onchangeHandler) throws IOException {
        if (!render) {
            return;
        }
        out.startElement("select", null);
        out.writeAttribute("name", (Object)selectId, null);
        out.writeAttribute("id", (Object)selectId, null);
        out.writeAttribute("onchange", (Object)onchangeHandler, null);
        out.write("\n");
        for (int i = 0; i < optionValues.length; ++i) {
            String optionText = optionTexts[i];
            String optionValue = optionValues[i];
            out.startElement("option", null);
            if (optionValue.equals(selectedValue)) {
                out.writeAttribute("selected", (Object)"selected", null);
            }
            out.writeAttribute("value", (Object)optionValue, null);
            out.writeText((Object)optionText, null);
            out.endElement("option");
            out.write("\n");
        }
        out.endElement("select");
        out.write("\n");
    }

    public void decode(FacesContext context, UIComponent component) {
        Map req = context.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(context);
        String idFirst = clientId + "_first";
        String idPrev = clientId + "_prev";
        String idNext = clientId + "_next";
        String idLast = clientId + "_last";
        String idSelect = clientId + "_pageSize";
        String idPastItem = clientId + "_pastItem";
        int firstItem = PagerRenderer.getInt(context, component, "firstItem", 0);
        int lastItem = PagerRenderer.getInt(context, component, "lastItem", 0);
        int pageSize = PagerRenderer.getInt(context, component, "pageSize", 0);
        int totalItems = PagerRenderer.getInt(context, component, "totalItems", 0);
        if (log.isDebugEnabled()) {
            log.debug("decode: firstItem=" + firstItem + ", pageSize=" + pageSize + ", value=" + PagerRenderer.getString(context, component, "value", null));
        }
        int newFirstItem = firstItem;
        int newLastItem = lastItem;
        int newPageSize = pageSize;
        String str = (String)req.get(idPastItem);
        if (str != null && firstItem == Integer.valueOf(str)) {
            if (req.containsKey(idFirst)) {
                newFirstItem = 0;
            } else if (req.containsKey(idPrev)) {
                newFirstItem = Math.max(firstItem - pageSize, 0);
            } else if (req.containsKey(idNext)) {
                newFirstItem = Math.min(firstItem + pageSize, totalItems - 1);
            } else if (req.containsKey(idLast)) {
                int lastPage = (totalItems - 1) / pageSize;
                newFirstItem = lastPage * pageSize;
            } else if (req.containsKey(idSelect)) {
                newPageSize = Integer.parseInt((String)req.get(idSelect));
            }
        }
        PagerRenderer.adjustState(context, component, firstItem, lastItem, pageSize, totalItems, newFirstItem, newLastItem, newPageSize);
    }

    private static String formatValue(int firstItem, int pageSize) {
        return firstItem + "," + pageSize;
    }

    private static void adjustState(FacesContext context, UIComponent component, int firstItem, int lastItem, int pageSize, int totalItems, int newFirstItem, int newLastItem, int newPageSize) {
        String oldValue;
        newLastItem = Math.min(newFirstItem + newPageSize, totalItems);
        if (newPageSize <= 0) {
            newFirstItem = 0;
            newLastItem = totalItems;
        }
        if (newLastItem != lastItem) {
            RendererUtil.setAttribute(context, component, "lastItem", new Integer(newLastItem));
        }
        if (newPageSize != pageSize) {
            RendererUtil.setAttribute(context, component, "pageSize", new Integer(newPageSize));
        }
        if (newFirstItem != firstItem) {
            RendererUtil.setAttribute(context, component, "firstItem", new Integer(newFirstItem));
        }
        EditableValueHolder evh = (EditableValueHolder)component;
        String newValue = PagerRenderer.formatValue(newFirstItem, newPageSize);
        if (!newValue.equals(oldValue = (String)evh.getValue())) {
            if (oldValue != null) {
                evh.setSubmittedValue((Object)newValue);
                evh.setValid(true);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("initializing value to " + newValue);
                }
                evh.setValue((Object)newValue);
            }
        }
    }

    private static int getInt(FacesContext context, UIComponent component, String attrName, int def) {
        Object ret = PagerRenderer.getFromAttributeOrBundle(context, component, attrName);
        if (ret instanceof Integer) {
            return (Integer)ret;
        }
        if (ret instanceof String) {
            return Integer.valueOf((String)ret);
        }
        return def;
    }

    private static boolean getBoolean(FacesContext context, UIComponent component, String attrName, boolean def) {
        Object ret = PagerRenderer.getFromAttributeOrBundle(context, component, attrName);
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        if (ret instanceof String) {
            return Boolean.valueOf((String)ret);
        }
        return def;
    }

    private static String getString(FacesContext context, UIComponent component, String attrName, String def) {
        String ret = (String)PagerRenderer.getFromAttributeOrBundle(context, component, attrName);
        if (ret != null) {
            return ret;
        }
        return def;
    }

    private static Object getFromAttributeOrBundle(FacesContext context, UIComponent component, String name) {
        Object ret = RendererUtil.getAttribute(context, component, name);
        if (ret != null) {
            return ret;
        }
        String str = null;
        try {
            str = LocaleUtil.getLocalizedString(context, BUNDLE_NAME, "pager_" + name);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (str != null && str.length() > 0) {
            return str;
        }
        return null;
    }
}

