/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.sakaiproject.jsf.component.RichTextAreaComponent;
import org.sakaiproject.jsf.util.RendererUtil;
import org.sakaiproject.util.FormattedText;

public class RichTextAreaRenderer
extends Renderer {
    public boolean supportsComponentType(UIComponent component) {
        return component instanceof RichTextAreaComponent;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String clientId = component.getClientId(context);
        String textareaId = clientId + "_textarea";
        ResponseWriter writer = context.getResponseWriter();
        Object value = null;
        if (component instanceof UIInput) {
            value = ((UIInput)component).getSubmittedValue();
        }
        if (value == null && component instanceof ValueHolder) {
            value = ((ValueHolder)component).getValue();
        }
        if (value == null) {
            value = "";
        }
        value = FormattedText.escapeHtmlFormattedTextarea((String)((String)value));
        int columns = -1;
        String columnsStr = (String)RendererUtil.getAttribute(context, component, "columns");
        if (columnsStr != null && columnsStr.length() > 0) {
            columns = Integer.parseInt(columnsStr);
        }
        int rows = -1;
        String rowsStr = (String)RendererUtil.getAttribute(context, component, "rows");
        if (rowsStr != null && rowsStr.length() > 0) {
            rows = Integer.parseInt(rowsStr);
        }
        writer.write("<table border=\"0\"><tr><td>");
        writer.write("<textarea name=\"" + textareaId + "\" id=\"" + textareaId + "\"");
        if (columns > 0) {
            writer.write(" cols=\"" + columns + "\"");
        }
        if (rows > 0) {
            writer.write(" rows=\"" + rows + "\"");
        }
        writer.write(">");
        if (value != null) {
            writer.write((String)value);
        }
        writer.write("</textarea>");
        writer.write("<script type=\"text/javascript\">sakai.editor.launch('" + textareaId + "');</script>");
        writer.write("</td></tr></table>\n");
    }

    public void decode(FacesContext context, UIComponent component) {
        if (null == context || null == component || !(component instanceof RichTextAreaComponent)) {
            throw new IllegalArgumentException();
        }
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestParameterMap.get(clientId + "_textarea");
        RichTextAreaComponent comp = (RichTextAreaComponent)component;
        comp.setSubmittedValue(newValue);
    }
}

