/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.sakaiproject.jsf.util.RendererUtil;

public class SeparatedListRenderer
extends Renderer {
    public boolean getRendersChildren() {
        return true;
    }

    public boolean supportsComponentType(UIComponent component) {
        return component instanceof UIOutput;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        String clientId = null;
        if (component.getId() != null && !component.getId().startsWith("_id")) {
            clientId = component.getClientId(context);
        }
        ResponseWriter writer = context.getResponseWriter();
        if (clientId != null) {
            String styleClass = (String)RendererUtil.getAttribute(context, component, "styleClass");
            writer.startElement("div", component);
            writer.writeAttribute("id", (Object)clientId, "id");
            writer.writeAttribute("class", (Object)styleClass, "class");
        }
        List children = component.getChildren();
        String separator = (String)RendererUtil.getAttribute(context, component, "separator");
        if (separator == null) {
            separator = " | ";
        }
        boolean first = true;
        for (UIComponent child : children) {
            if (!child.isRendered()) continue;
            if (!first) {
                writer.write(separator);
            }
            RendererUtil.encodeRecursive(context, child);
            first = false;
        }
        if (clientId != null) {
            writer.endElement("div");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }
}

