/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.sakaiproject.jsf.component.ToolBarComponent;
import org.sakaiproject.jsf.util.RendererUtil;

public class ToolBarRenderer
extends Renderer {
    public boolean getRendersChildren() {
        return true;
    }

    public boolean supportsComponentType(UIComponent component) {
        return component instanceof ToolBarComponent;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.write("<ul class=\"navIntraTool actionToolbar\">");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        String clientId = null;
        if (component.getId() != null && !component.getId().startsWith("_id")) {
            clientId = component.getClientId(context);
        }
        ResponseWriter writer = context.getResponseWriter();
        if (clientId != null) {
            writer.startElement("ul", component);
        }
        List children = component.getChildren();
        String separator = (String)RendererUtil.getAttribute(context, component, "separator");
        if (separator == null) {
            separator = "";
        }
        boolean first = true;
        boolean foundCurrent = false;
        for (UIComponent child : children) {
            if (!child.isRendered()) continue;
            if (!first) {
                writer.write("<li>");
            } else {
                writer.write("<li class=\"firstToolBarItem\">");
            }
            boolean current = false;
            if (!foundCurrent) {
                boolean hasCurrentIndicated = child.getAttributes().get("current") != null;
                boolean bl = current = hasCurrentIndicated && (Boolean)child.getAttributes().get("current") != false;
            }
            if (current) {
                foundCurrent = true;
                writer.write("<span class=\"current\">");
            } else {
                writer.write("<span>");
            }
            RendererUtil.encodeRecursive(context, child);
            writer.write("</span></li> ");
            first = false;
        }
        if (clientId != null) {
            writer.endElement("ul");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write("</ul>");
    }
}

