/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleUtil {
    private static final Logger log = LoggerFactory.getLogger(LocaleUtil.class);
    private static Object sakaiResourceLoader = null;
    private static Method sakaiResourceLoaderGetLocale;
    private static Method sakaiResourceLoaderGetOrientation;
    private static boolean isInitialized;

    private static void init() {
        if (!isInitialized) {
            try {
                Class<?> sakaiResourceLoaderClass = Class.forName("org.sakaiproject.util.ResourceLoader");
                if (log.isDebugEnabled()) {
                    log.debug("Found Sakai ResourceLoader class");
                }
                Constructor<?> sakaiResourceLoaderConstructor = sakaiResourceLoaderClass.getConstructor(new Class[0]);
                sakaiResourceLoaderGetLocale = sakaiResourceLoaderClass.getMethod("getLocale", new Class[0]);
                sakaiResourceLoaderGetOrientation = sakaiResourceLoaderClass.getMethod("getOrientation", Locale.class);
                sakaiResourceLoader = sakaiResourceLoaderConstructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                log.debug("Did not find Sakai ResourceLoader class; will use standard JSF localization");
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.error("Will use standard JSF localization", (Throwable)e);
            }
            isInitialized = true;
        }
    }

    public static Locale getLocale(FacesContext context) {
        Locale locale = null;
        LocaleUtil.init();
        if (sakaiResourceLoader != null) {
            try {
                locale = (Locale)sakaiResourceLoaderGetLocale.invoke(sakaiResourceLoader, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                log.error(e.getMessage());
            }
        } else {
            locale = context.getViewRoot().getLocale();
        }
        return locale;
    }

    public static String getLocalizedString(FacesContext context, String bundleName, String key) {
        String localized = null;
        Locale locale = LocaleUtil.getLocale(context);
        ResourceBundle rb = ResourceBundle.getBundle(bundleName, locale);
        if (log.isDebugEnabled()) {
            log.debug("getLocalizedString; locale=" + locale.getDisplayName() + ", bundleName=" + bundleName + ", rb=" + rb.getLocale() + ", rb getCountry()=" + rb.getLocale().getCountry());
        }
        localized = rb.getString(key);
        return localized;
    }

    public static String getOrientation(Locale loc) {
        String orientation = "ltr";
        LocaleUtil.init();
        if (sakaiResourceLoader != null) {
            try {
                orientation = (String)sakaiResourceLoaderGetOrientation.invoke(sakaiResourceLoader, loc);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                log.error(e.getMessage());
            }
        }
        return orientation;
    }

    static {
        isInitialized = false;
    }
}

