/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;

public class RendererUtil {
    private RendererUtil() {
    }

    public static void setAttribute(FacesContext context, UIComponent component, String name, Object value) {
        ValueBinding binding = component.getValueBinding(name);
        if (binding != null) {
            try {
                binding.setValue(context, value);
            }
            catch (IllegalArgumentException e) {
                binding.setValue(context, (Object)String.valueOf(value));
            }
        } else {
            component.getAttributes().put(name, value);
        }
    }

    public static Object getAttribute(FacesContext context, UIComponent component, String name) {
        Object ret = component.getAttributes().get(name);
        if (ret != null) {
            return ret;
        }
        ValueBinding vb = component.getValueBinding(name);
        if (vb != null) {
            ret = vb.getValue(context);
        }
        return ret;
    }

    public static Object getDefaultedAttribute(FacesContext context, UIComponent component, String name, Object defaultValue) {
        Object o = RendererUtil.getAttribute(context, component, name);
        if (o == null) {
            o = defaultValue;
        }
        return o;
    }

    public static void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            for (UIComponent child : component.getChildren()) {
                RendererUtil.encodeRecursive(context, child);
            }
        }
        component.encodeEnd(context);
    }

    public static boolean isDisabledOrReadonly(FacesContext context, UIComponent component) {
        Object readOnlyAttr;
        boolean disabled = false;
        boolean readOnly = false;
        Object disabledAttr = RendererUtil.getAttribute(context, component, "disabled");
        if (disabledAttr != null) {
            disabled = disabledAttr.equals(Boolean.TRUE);
        }
        if ((readOnlyAttr = RendererUtil.getAttribute(context, component, "readonly")) != null) {
            readOnly = readOnlyAttr.equals(Boolean.TRUE);
        }
        return readOnly | disabled;
    }

    public static void writePassthroughs(FacesContext context, UIComponent component) throws IOException {
        String[] passthrus = new String[]{"ondblclick", "onclick", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup"};
        RendererUtil.writePassthroughAttributes(passthrus, true, context, component);
    }

    public static void writePassthroughAttributes(String[] passthrus, boolean writeNullAttrs, FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (int i = 0; i < passthrus.length; ++i) {
            String key = passthrus[i];
            String value = (String)RendererUtil.getAttribute(context, component, key);
            if (writeNullAttrs && value == null) {
                value = "";
            }
            if (value == null) continue;
            writer.writeAttribute(key, (Object)value, null);
        }
    }

    public static void writeAttributes(Map attributeMap, ResponseWriter writer) throws IOException {
        for (Map.Entry entry : attributeMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                value = "";
            }
            writer.writeAttribute(key, (Object)value, key);
        }
    }

    public static void writeAttributes(Map attributeMap, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        RendererUtil.writeAttributes(attributeMap, writer);
    }

    public static void writeSmartExternalScripts(FacesContext context, String gateKey, String gateValue, String contextBasePath, String[] scriptPaths) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        RendererUtil.writeSmartExternalScripts(writer, gateKey, gateValue, contextBasePath, scriptPaths);
    }

    public static void writeSmartExternalScripts(ResponseWriter writer, String gateKey, String gateValue, String contextBasePath, String[] scriptPaths) throws IOException {
        writer.write("<script>");
        writer.write("  if (typeof window['" + gateKey + "'] == '" + gateValue + "')");
        writer.write("  {");
        for (int i = 0; i < scriptPaths.length; ++i) {
            writer.write("    document.write(");
            writer.write("   \"<\" + \"script type='text/javascript' src='/'\" + " + contextBasePath + " +");
            writer.write("   \"'" + scriptPaths[i] + "'><\" + \"/script>);");
        }
        writer.write("   var " + gateKey + " = '" + gateValue + "';");
        writer.write("  }");
        writer.write("</script>");
        writer.write("");
        writer.write("");
    }

    public static Map mapComponentAttributes(Collection collection, UIComponent component) {
        HashMap attributeMap = new HashMap();
        if (collection == null) {
            return attributeMap;
        }
        String[] attributeNames = new String[collection.size()];
        Object[] objs = collection.toArray();
        for (int i = 0; i < objs.length; ++i) {
            attributeNames[i] = (String)objs[i];
        }
        return RendererUtil.mapComponentAttributes(attributeNames, component);
    }

    public static Map mapComponentAttributes(String[] attributeNames, UIComponent component) {
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeMap.put(attributeNames[i], (String)component.getAttributes().get(attributeNames[i]));
        }
        return attributeMap;
    }

    public static String makeSwitchString(String rawSwitch, boolean supportOnOff, boolean supportTrueFalse, boolean supportYesNo, boolean returnOnOff, boolean returnYesNo, boolean defaultValue) {
        boolean switchValue = defaultValue;
        String trueString = "true";
        String falseString = "false";
        if (returnOnOff) {
            trueString = "on";
            falseString = "off";
        } else if (returnYesNo) {
            trueString = "yes";
            falseString = "no";
        }
        if (supportOnOff) {
            if ("on".equalsIgnoreCase(rawSwitch)) {
                switchValue = true;
            }
            if ("off".equalsIgnoreCase(rawSwitch)) {
                switchValue = false;
            }
        }
        if (supportTrueFalse) {
            if ("true".equalsIgnoreCase(rawSwitch)) {
                switchValue = true;
            }
            if ("false".equalsIgnoreCase(rawSwitch)) {
                switchValue = false;
            }
        }
        if (supportYesNo) {
            if ("yes".equalsIgnoreCase(rawSwitch)) {
                switchValue = true;
            }
            if ("no".equalsIgnoreCase(rawSwitch)) {
                switchValue = false;
            }
        }
        if (switchValue) {
            return trueString;
        }
        return falseString;
    }

    public static void renderMenu(ResponseWriter out, List items, int selected, String clientId, String styleClass, UIComponent component) throws IOException {
        out.startElement("select", component);
        out.writeAttribute("name", (Object)clientId, "id");
        out.writeAttribute("id", (Object)clientId, "id");
        if (styleClass != null) {
            out.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        for (SelectItem si : items) {
            Integer value = (Integer)si.getValue();
            String label = si.getLabel();
            out.startElement("option", component);
            out.writeAttribute("value", (Object)value, null);
            if (value == selected) {
                out.writeAttribute("selected", (Object)"selected", null);
            }
            out.writeText((Object)label, null);
        }
        out.endElement("select");
    }

    public static String getFormId(FacesContext context, UIComponent component) {
        while (component != null && !(component instanceof UIForm)) {
            component = component.getParent();
        }
        if (component != null) {
            return ((UIForm)component).getId();
        }
        return null;
    }

    public static void writeExternalJSDependencies(FacesContext context, ResponseWriter writer, String key, String path) throws IOException {
        HttpServletRequest req = (HttpServletRequest)context.getExternalContext().getRequest();
        String jsInclude = (String)req.getAttribute(key);
        if (jsInclude == null || jsInclude.length() == 0) {
            jsInclude = "<script type=\"text/javascript\" src=\"" + path + "\"></script>\n";
            req.setAttribute(key, (Object)jsInclude);
            writer.write(jsInclude);
        }
    }

    public static void writeExternalCSSDependencies(FacesContext context, ResponseWriter writer, String key, String path) throws IOException {
        HttpServletRequest req = (HttpServletRequest)context.getExternalContext().getRequest();
        String cssInclude = (String)req.getAttribute(key);
        if (cssInclude == null || cssInclude.length() == 0) {
            cssInclude = "<link href=\"" + path + "\" type=\"text/css\" rel=\"stylesheet\" media=\"all\" />\n";
            req.setAttribute(key, (Object)cssInclude);
            writer.write(cssInclude);
        }
    }

    public static void writeAttr(Writer inWriter, String inAttr, String inAttrValue) throws IOException {
        if (inWriter == null || inAttr == null || inAttrValue == null) {
            return;
        }
        inWriter.write(" ");
        inWriter.write(inAttr);
        inWriter.write("=\"");
        inWriter.write(inAttrValue);
        inWriter.write("\" ");
    }
}

