/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.util;

import java.io.Serializable;
import java.util.HashMap;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.webapp.UIComponentTag;

public class TagUtil {
    private TagUtil() {
    }

    public static void setString(UIComponent component, String name, String value) {
        if (value == null) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            TagUtil.setValueBinding(component, name, value);
        } else {
            component.getAttributes().put(name, value);
        }
    }

    public static void setObject(UIComponent component, String name, String value) {
        if (value == null) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            TagUtil.setValueBinding(component, name, value);
        } else {
            component.getAttributes().put(name, value);
        }
    }

    public static void setInteger(UIComponent component, String name, String value) {
        if (value == null) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            TagUtil.setValueBinding(component, name, value);
        } else {
            component.getAttributes().put(name, Integer.valueOf(value));
        }
    }

    public static void setMap(UIComponent component, String name, String value) {
        if (value == null) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            TagUtil.setValueBinding(component, name, value);
        } else {
            component.getAttributes().put(name, new HashMap());
        }
    }

    public static void setDouble(UIComponent component, String name, String value) {
        if (value == null) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            TagUtil.setValueBinding(component, name, value);
        } else {
            component.getAttributes().put(name, Double.valueOf(value));
        }
    }

    public static void setBoolean(UIComponent component, String name, String value) {
        if (value == null) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            TagUtil.setValueBinding(component, name, value);
        } else {
            component.getAttributes().put(name, Boolean.valueOf(value));
        }
    }

    public static void setValueBinding(UIComponent component, String name, String value) {
        FacesContext context = FacesContext.getCurrentInstance();
        Application app = context.getApplication();
        ValueBinding vb = app.createValueBinding(value);
        component.setValueBinding(name, vb);
    }

    public static void setActionListener(UIComponent component, String value) {
        TagUtil.setMethodBinding(component, "actionListener", value, new Class[]{ActionEvent.class});
    }

    public static void setValueChangeListener(UIComponent component, String value) {
        TagUtil.setMethodBinding(component, "valueChangeListener", value, new Class[]{ValueChangeEvent.class});
    }

    public static void setValidator(UIComponent component, String value) {
        TagUtil.setMethodBinding(component, "validator", value, new Class[]{FacesContext.class, UIComponent.class, Object.class});
    }

    public static void setAction(UIComponent component, String value) {
        if (value == null) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            TagUtil.setMethodBinding(component, "action", value, new Class[0]);
        } else {
            FacesContext context = FacesContext.getCurrentInstance();
            Application app = context.getApplication();
            ActionMethodBinding mb = new ActionMethodBinding(value);
            component.getAttributes().put("action", mb);
        }
    }

    public static void setMethodBinding(UIComponent component, String name, String value, Class[] paramTypes) {
        if (value == null) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            FacesContext context = FacesContext.getCurrentInstance();
            Application app = context.getApplication();
            MethodBinding mb = app.createMethodBinding(value, paramTypes);
            component.getAttributes().put(name, mb);
        }
    }

    public static String eval(String expression) {
        if (expression == null) {
            return null;
        }
        if (UIComponentTag.isValueReference((String)expression)) {
            FacesContext context = FacesContext.getCurrentInstance();
            Application app = context.getApplication();
            return "" + app.createValueBinding(expression).getValue(context);
        }
        return expression;
    }

    public static Integer evalInteger(String expression) {
        if (expression == null) {
            return null;
        }
        if (UIComponentTag.isValueReference((String)expression)) {
            FacesContext context = FacesContext.getCurrentInstance();
            Application app = context.getApplication();
            Object r = app.createValueBinding(expression).getValue(context);
            if (r == null) {
                return null;
            }
            if (r instanceof Integer) {
                return (Integer)r;
            }
            return Integer.valueOf(r.toString());
        }
        return Integer.valueOf(expression);
    }

    public static Double evalDouble(String expression) {
        if (expression == null) {
            return null;
        }
        if (UIComponentTag.isValueReference((String)expression)) {
            FacesContext context = FacesContext.getCurrentInstance();
            Application app = context.getApplication();
            Object r = app.createValueBinding(expression).getValue(context);
            if (r == null) {
                return null;
            }
            if (r instanceof Double) {
                return (Double)r;
            }
            return Double.valueOf(r.toString());
        }
        return Double.valueOf(expression);
    }

    public static Boolean evalBoolean(String expression) {
        if (expression == null) {
            return null;
        }
        if (UIComponentTag.isValueReference((String)expression)) {
            FacesContext context = FacesContext.getCurrentInstance();
            Application app = context.getApplication();
            Object r = app.createValueBinding(expression).getValue(context);
            if (r == null) {
                return null;
            }
            if (r instanceof Boolean) {
                return (Boolean)r;
            }
            return Boolean.valueOf(r.toString());
        }
        return Boolean.valueOf(expression);
    }

    private static class ActionMethodBinding
    extends MethodBinding
    implements Serializable {
        private String result;

        public ActionMethodBinding(String result) {
            this.result = result;
        }

        public Object invoke(FacesContext context, Object[] params) {
            return this.result;
        }

        public String getExpressionString() {
            return this.result;
        }

        public Class getType(FacesContext context) {
            return String.class;
        }
    }
}

