/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.sakaiproject.jsf.util.RendererUtil;

public class AppletRenderer
extends Renderer {
    private static final String IE_CODEBASE = "http://java.sun.com/products/plugin/1.4/jinstall-14-win32.cab#Version=1,4,0,mn";
    private static final String NS_PLUGINSPAGE = "http://java.sun.com/products/plugin/1.4/plugin-install.html";
    private static final String VERSION = "1.4";
    private static final String DEFAULT_WIDTH = "200";
    private static final String DEFAULT_HEIGHT = "200";
    private static final String DEFAULT_VSPACE = "0";
    private static final String DEFAULT_HSPACE = "0";

    public boolean supportsComponentType(UIComponent component) {
        return component instanceof UIOutput;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        String width = (String)RendererUtil.getDefaultedAttribute(context, component, "width", "200");
        String height = (String)RendererUtil.getDefaultedAttribute(context, component, "height", "200");
        String vspace = (String)RendererUtil.getDefaultedAttribute(context, component, "vspace", "0");
        String hspace = (String)RendererUtil.getDefaultedAttribute(context, component, "hspace", "0");
        String javaClass = (String)RendererUtil.getAttribute(context, component, "javaClass");
        String javaArchive = (String)RendererUtil.getAttribute(context, component, "javaArchive");
        String codebase = (String)RendererUtil.getAttribute(context, component, "codebase");
        String paramList = (String)RendererUtil.getAttribute(context, component, "paramList");
        String name = (String)RendererUtil.getAttribute(context, component, "name");
        Map appParamMap = this.makeAppletParameters(paramList);
        if (null != codebase) {
            appParamMap.put("codebase", codebase);
        }
        if (null != javaArchive) {
            appParamMap.put("archive", javaArchive);
        }
        appParamMap.put("code", javaClass);
        ResponseWriter writer = context.getResponseWriter();
        this.renderApplet(width, height, vspace, hspace, codebase, javaClass, javaArchive, name, appParamMap, writer);
    }

    private Map makeAppletParameters(String paramList) {
        HashMap<String, String> appParamMap = new HashMap<String, String>();
        if (paramList != null) {
            StringTokenizer paramsTokenizer = new StringTokenizer(paramList, ",", false);
            while (paramsTokenizer.hasMoreTokens()) {
                StringTokenizer nameValueTokenizer = new StringTokenizer(paramsTokenizer.nextToken(), "=", false);
                if (nameValueTokenizer.countTokens() < 2) continue;
                String name = nameValueTokenizer.nextToken();
                String value = nameValueTokenizer.nextToken();
                appParamMap.put(name, value);
            }
        }
        return appParamMap;
    }

    private void renderApplet(String width, String height, String vspace, String hspace, String codebase, String javaClass, String javaArchive, String name, Map appParamMap, ResponseWriter writer) throws IOException {
        writer.write("");
        writer.write("<OBJECT ");
        writer.write("    classid=\"clsid:8AD9C840-044E-11D1-B3E9-00805F499D93\" ");
        writer.write("    width=\"" + width + "\" ");
        writer.write("    height=\"" + height + "\" ");
        writer.write("    hspace=\"" + hspace + "\" ");
        writer.write("    vspace=\"" + vspace + "\" ");
        writer.write("    codebase=\"http://java.sun.com/products/plugin/1.4/jinstall-14-win32.cab#Version=1,4,0,mn\"");
        writer.write("    archive=\"" + javaArchive + "\"");
        writer.write("    id=\"" + name + "\"");
        writer.write(">");
        writer.write("    <PARAM name=\"type\" value=\"application/x-java-applet;version=1.4\">");
        this.renderObjectParams(writer, appParamMap);
        writer.write("<COMMENT>");
        writer.write("<EMBED ");
        writer.write("    type=\"application/x-java-applet;version=1.4\" ");
        writer.write("    width=\"" + width + "\" ");
        writer.write("    height=\"" + height + "\" ");
        writer.write("    hspace=\"" + hspace + "\" ");
        writer.write("    vspace=\"" + vspace + "\" ");
        writer.write("    pluginspage=\"http://java.sun.com/products/plugin/1.4/plugin-install.html\" ");
        if (null != name) {
            appParamMap.put("id", name);
            appParamMap.put("name", name);
        }
        this.renderEmbedParams(writer, appParamMap);
        writer.write("/>");
        writer.write("");
        writer.write("<NOEMBED>");
        writer.write("    <font color=\"red\">");
        writer.write("    Note: Requires Java Plug-in 1.4.");
        writer.write("    </b></font><br/>");
        writer.write("</NOEMBED>");
        writer.write("</COMMENT>");
        writer.write("</OBJECT>");
    }

    private void renderEmbedParams(ResponseWriter writer, Map appParamMap) throws IOException {
        for (Map.Entry entrySet : appParamMap.entrySet()) {
            String name = (String)entrySet.getKey();
            String value = (String)entrySet.getValue();
            writer.write("    " + name + "=\"" + value + "\" ");
        }
    }

    private void renderObjectParams(ResponseWriter writer, Map appParamMap) throws IOException {
        for (Map.Entry entrySet : appParamMap.entrySet()) {
            String name = (String)entrySet.getKey();
            String value = (String)entrySet.getValue();
            writer.write("    <PARAM name=\"" + name + "\" value=\"" + value + "\">");
        }
    }
}

