/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class DebugRenderer
extends Renderer {
    public boolean supportsComponentType(UIComponent component) {
        return component instanceof UIOutput;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.write("<xmp>");
        writer.write("***** DEBUG TAG RENDER OUTPUT *****\n\n");
        this.dumpJSFVariable("applicationScope", context);
        this.dumpJSFVariable("sessionScope", context);
        this.dumpJSFVariable("requestScope", context);
        this.dumpJSFVariable("toolScope", context);
        this.dumpJSFVariable("toolConfig", context);
        this.dumpJSFVariable("param", context);
        writer.write("</xmp>");
    }

    private void dumpJSFVariable(String varName, FacesContext context) throws IOException {
        Object varValue = context.getApplication().getVariableResolver().resolveVariable(context, varName);
        ResponseWriter writer = context.getResponseWriter();
        if (varValue instanceof Map) {
            this.dumpMap((Map)varValue, varName, writer);
        } else {
            writer.write(varName);
            writer.write(": ");
            writer.write(String.valueOf(varValue));
            writer.write("\n\n");
        }
    }

    private void dumpMap(Map map, String mapName, ResponseWriter writer) throws IOException {
        writer.write(mapName);
        if (map == null) {
            writer.write(" is null\n\n");
            return;
        }
        writer.write(" " + map + " contains: \n");
        for (Map.Entry entry : map.entrySet()) {
            Object name = entry.getKey();
            Object value = entry.getValue();
            writer.write(String.valueOf(name));
            writer.write(" -> ");
            writer.write(String.valueOf(value));
            writer.write(10);
        }
        writer.write("\n\n");
    }
}

