/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.renderer;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.sakaiproject.jsf.util.ConfigurationResource;
import org.sakaiproject.jsf.util.RendererUtil;

public class InputColorRenderer
extends Renderer {
    private static final String HEIGHT = "13";
    private static final String WIDTH = "15";
    private static final String TYPE = "text";
    private static final String CURSORSTYLE;
    private static final String CLICKALT;
    private static final String COLOR_PATH;
    private static final String COLOR_ICON;

    public boolean supportsComponentType(UIComponent component) {
        return component instanceof UIInput;
    }

    public void decode(FacesContext context, UIComponent component) {
        if (RendererUtil.isDisabledOrReadonly(context, component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestParameterMap.get(clientId);
        UIInput comp = (UIInput)component;
        comp.setSubmittedValue((Object)newValue);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String size;
        if (RendererUtil.isDisabledOrReadonly(context, component) || !component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String contextPath = context.getExternalContext().getRequestContextPath();
        Object value = null;
        if (component instanceof UIInput) {
            value = ((UIInput)component).getSubmittedValue();
        }
        if (value == null && component instanceof ValueHolder) {
            value = ((ValueHolder)component).getValue();
        }
        String valString = "";
        if (value != null) {
            valString = value.toString();
        }
        if ((size = (String)RendererUtil.getAttribute(context, component, "size")) == null) {
            size = "20";
        }
        String clientId = component.getClientId(context);
        writer.write("\n");
        writer.write(" <input ");
        writer.write("\n");
        writer.write("  value=\"" + valString + "\" \n");
        writer.write("  type=\"text\" \n");
        writer.write("  size=\"" + size + "\" \n");
        writer.write("  name=\"" + clientId + "\"\n");
        writer.write("  id=\"" + clientId + "\" />&#160;");
        writer.write("<img ");
        writer.write("  id=\"" + clientId + "_colorPickerPopup" + "\"");
        writer.write("  style=\"" + CURSORSTYLE + "\" ");
        writer.write("  height=\"13\" ");
        writer.write("  width=\"15\"");
        writer.write("  src=\"" + COLOR_ICON + "\" ");
        writer.write("  border=\"0\"");
        writer.write("  alt=\"" + CLICKALT + "\" ");
        writer.write("  onclick=\"javascript:TCP.popup(document.getElementById('" + clientId + "'),'','" + COLOR_PATH + "')\" />");
        writer.write("&#160;");
    }

    static {
        ConfigurationResource cr = new ConfigurationResource();
        String resources = cr.get("resources");
        CURSORSTYLE = cr.get("picker_style");
        COLOR_PATH = "/" + resources + "/" + cr.get("inputColorPopup");
        COLOR_ICON = "/" + resources + "/" + cr.get("inputColorImage");
        CLICKALT = cr.get("color_pick_alt");
    }
}

